/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.enums.ContentType;
import io.mangoo.enums.Default;
import io.mangoo.routing.Response;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Objects;

public class BinaryHandler
implements HttpHandler {
    private final Response response;

    public BinaryHandler(Response response) {
        this.response = Objects.requireNonNull(response, "response can not be null");
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        httpServerExchange.startBlocking();
        httpServerExchange.setStatusCode(this.response.getStatusCode());
        httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ContentType.APPLICATION_OCTET_STREAM.toString());
        httpServerExchange.getResponseHeaders().put(Headers.CONTENT_DISPOSITION, "inline; filename=" + this.response.getBinaryFileName());
        httpServerExchange.getResponseHeaders().put(Headers.SERVER, Default.SERVER.toString());
        this.response.getHeaders().forEach((httpString, string) -> httpServerExchange.getResponseHeaders().add(httpString, string));
        httpServerExchange.getOutputStream().write(this.response.getBinaryContent());
    }
}

