/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Key;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.crypto.Crypto;
import io.mangoo.i18n.Messages;
import io.mangoo.interfaces.MangooRequestFilter;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.handlers.LocaleHandler;
import io.mangoo.routing.listeners.MetricsListener;
import io.mangoo.templating.TemplateEngine;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DispatcherHandler
implements HttpHandler {
    private static final Config CONFIG = Application.getConfig();
    private static final Logger LOG = LogManager.getLogger(DispatcherHandler.class);
    private Method method;
    private final TemplateEngine templateEngine;
    private final Messages messages;
    private final Crypto crypto;
    private final MetricsListener metricsListener;
    private final Map<String, Class<?>> methodParameters;
    private final Class<?> controllerClass;
    private final String controllerClassName;
    private final String controllerMethodName;
    private final int methodParametersCount;
    private final boolean metrics;
    private final boolean async;
    private final boolean hasRequestFilter;

    public DispatcherHandler(Class<?> clazz, String string, boolean bl) {
        Objects.requireNonNull(clazz, "controllerClass can not be null");
        Objects.requireNonNull(string, "controllerMethod can not be null");
        this.templateEngine = Application.getInstance(TemplateEngine.class);
        this.messages = Application.getInstance(Messages.class);
        this.metricsListener = Application.getInstance(MetricsListener.class);
        this.crypto = Application.getInstance(Crypto.class);
        this.controllerClass = clazz;
        this.controllerMethodName = string;
        this.controllerClassName = clazz.getSimpleName();
        this.methodParameters = this.getMethodParameters();
        this.methodParametersCount = this.methodParameters.size();
        this.async = bl;
        this.hasRequestFilter = Application.getInjector().getAllBindings().containsKey(Key.get(MangooRequestFilter.class));
        this.metrics = CONFIG.isAdminMetricsEnabled();
        try {
            this.method = Application.getInstance(this.controllerClass).getClass().getMethod(this.controllerMethodName, this.methodParameters.values().toArray(new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            LOG.error("Failed to create DispatcherHandler", (Throwable)exception);
        }
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        if ((RequestUtils.isPostOrPut(httpServerExchange) || this.async) && httpServerExchange.isInIoThread()) {
            httpServerExchange.dispatch((HttpHandler)this);
            return;
        }
        if (this.metrics) {
            httpServerExchange.addResponseCommitListener((ResponseCommitListener)this.metricsListener);
        }
        Attachment attachment = Attachment.build().withControllerInstance(Application.getInstance(this.controllerClass)).withControllerClass(this.controllerClass).withControllerClassName(this.controllerClassName).withControllerMethodName(this.controllerMethodName).withMethodParameters(this.methodParameters).withMethod(this.method).withMethodParameterCount(this.methodParametersCount).withRequestFilter(this.hasRequestFilter).withRequestParameter(RequestUtils.getRequestParameters(httpServerExchange)).withMessages(this.messages).withTemplateEngine(this.templateEngine).withCrypto(this.crypto);
        httpServerExchange.putAttachment(RequestUtils.ATTACHMENT_KEY, (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    private Map<String, Class<?>> getMethodParameters() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Method method : this.controllerClass.getDeclaredMethods()) {
            if (!method.getName().equals(this.controllerMethodName) || method.getParameterCount() <= 0) continue;
            Arrays.asList(method.getParameters()).forEach(parameter -> linkedHashMap.put(parameter.getName(), parameter.getType()));
            break;
        }
        return linkedHashMap;
    }

    private void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(LocaleHandler.class).handleRequest(httpServerExchange);
    }
}

