/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.core.Application;
import io.mangoo.enums.ContentType;
import io.mangoo.enums.Default;
import io.mangoo.enums.Header;
import io.mangoo.enums.Template;
import io.mangoo.templating.TemplateEngine;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(ExceptionHandler.class);
    private static final String MESSAGE = "Failed to pass an exception to the frontend";

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Throwable throwable = (Throwable)httpServerExchange.getAttachment(io.undertow.server.handlers.ExceptionHandler.THROWABLE);
        try {
            httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ContentType.TEXT_HTML.toString());
            httpServerExchange.getResponseHeaders().put(Header.X_XSS_PPROTECTION.toHttpString(), (long)Default.XSS_PROTECTION.toInt());
            httpServerExchange.getResponseHeaders().put(Header.X_CONTENT_TYPE_OPTIONS.toHttpString(), Default.NOSNIFF.toString());
            httpServerExchange.getResponseHeaders().put(Header.X_FRAME_OPTIONS.toHttpString(), Default.SAMEORIGIN.toString());
            httpServerExchange.getResponseHeaders().put(Headers.SERVER, Default.SERVER.toString());
            httpServerExchange.setStatusCode(500);
            if (Application.inDevMode()) {
                TemplateEngine templateEngine = Application.getInstance(TemplateEngine.class);
                if (throwable == null) {
                    httpServerExchange.getResponseSender().send(Template.DEFAULT.serverError());
                } else if (throwable.getCause() == null) {
                    httpServerExchange.getResponseSender().send(templateEngine.renderException(httpServerExchange, throwable, true));
                } else {
                    httpServerExchange.getResponseSender().send(templateEngine.renderException(httpServerExchange, throwable.getCause(), false));
                }
            } else {
                httpServerExchange.getResponseSender().send(Template.DEFAULT.serverError());
            }
        }
        catch (Exception exception) {
            if (throwable == null) {
                LOG.error(MESSAGE, (Throwable)exception);
            }
            LOG.error(MESSAGE, throwable);
        }
    }
}

