/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.common.base.Charsets;
import io.mangoo.core.Application;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.handlers.RequestHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HttpString;
import java.io.IOException;

public class FormHandler
implements HttpHandler {
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.ATTACHMENT_KEY);
        attachment.setForm(this.getForm(httpServerExchange));
        httpServerExchange.putAttachment(RequestUtils.ATTACHMENT_KEY, (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    protected Form getForm(HttpServerExchange httpServerExchange) throws IOException {
        Form form = Application.getInstance(Form.class);
        if (RequestUtils.isPostOrPut(httpServerExchange)) {
            FormParserFactory.Builder builder = FormParserFactory.builder();
            builder.setDefaultCharset(Charsets.UTF_8.name());
            FormDataParser formDataParser = builder.build().createParser(httpServerExchange);
            if (formDataParser != null) {
                httpServerExchange.startBlocking();
                FormData formData = formDataParser.parseBlocking();
                formData.forEach(string -> formData.get(string).forEach(formValue -> {
                    if (formValue.isFile()) {
                        form.addFile(formValue.getPath().toFile());
                    } else {
                        form.addValue(new HttpString(string).toString(), formValue.getValue());
                    }
                }));
                form.setSubmitted(true);
            }
        }
        return form;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(RequestHandler.class).handleRequest(httpServerExchange);
    }
}

