/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.common.base.Splitter;
import io.mangoo.authentication.Authentication;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.handlers.FormHandler;
import io.mangoo.utils.CookieParser;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class InboundCookiesHandler
implements HttpHandler {
    private static final Config CONFIG = Application.getConfig();
    private static final int TOKEN_LENGTH = 16;
    private Attachment requestAttachment;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.requestAttachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.ATTACHMENT_KEY);
        this.requestAttachment.setSession(this.getSessionCookie(httpServerExchange));
        this.requestAttachment.setAuthentication(this.getAuthenticationCookie(httpServerExchange));
        this.requestAttachment.setFlash(this.getFlashCookie(httpServerExchange));
        httpServerExchange.putAttachment(RequestUtils.ATTACHMENT_KEY, (Object)this.requestAttachment);
        this.nextHandler(httpServerExchange);
    }

    protected Session getSessionCookie(HttpServerExchange httpServerExchange) {
        CookieParser cookieParser = CookieParser.create(httpServerExchange, CONFIG.getSessionCookieName(), CONFIG.getApplicationSecret(), CONFIG.isSessionCookieEncrypt());
        Session session = cookieParser.hasValidSessionCookie() ? new Session(cookieParser.getSessionValues(), cookieParser.getAuthenticityToken(), cookieParser.getExpiresDate()) : new Session(new HashMap<String, String>(), RandomStringUtils.randomAlphanumeric((int)16), LocalDateTime.now().plusSeconds(CONFIG.getSessionExpires()));
        return session;
    }

    protected Authentication getAuthenticationCookie(HttpServerExchange httpServerExchange) {
        CookieParser cookieParser = CookieParser.create(httpServerExchange, CONFIG.getAuthenticationCookieName(), CONFIG.getApplicationSecret(), CONFIG.isAuthenticationCookieEncrypt());
        Authentication authentication = cookieParser.hasValidAuthenticationCookie() ? new Authentication(cookieParser.getExpiresDate(), cookieParser.getAuthenticatedUser()) : new Authentication(LocalDateTime.now().plusSeconds(CONFIG.getAuthenticationExpires()), null);
        return authentication;
    }

    protected Flash getFlashCookie(HttpServerExchange httpServerExchange) {
        String string;
        Flash flash = null;
        Cookie cookie = (Cookie)httpServerExchange.getRequestCookies().get(CONFIG.getFlashCookieName());
        if (cookie != null && StringUtils.isNotEmpty((CharSequence)(string = cookie.getValue())) && !"null".equals(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry entry : Splitter.on((String)"&").withKeyValueSeparator(":").split((CharSequence)cookie.getValue()).entrySet()) {
                hashMap.put((String)entry.getKey(), (String)entry.getValue());
            }
            flash = new Flash(hashMap);
            flash.setDiscard(true);
        }
        return flash == null ? new Flash() : flash;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(FormHandler.class).handleRequest(httpServerExchange);
    }
}

