/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.core.Application;
import io.mangoo.managers.WebSocketManager;
import io.mangoo.routing.listeners.WebSocketCloseListener;
import io.mangoo.utils.RequestUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.xnio.ChannelListener;

public class WebSocketHandler
implements WebSocketConnectionCallback {
    private final boolean requiresAuthentication;
    private final Class<?> controllerClass;

    public WebSocketHandler(Class<?> clazz, boolean bl) {
        this.controllerClass = Objects.requireNonNull(clazz, "controllerClass can not be null");
        this.requiresAuthentication = bl;
    }

    public void onConnect(WebSocketHttpExchange webSocketHttpExchange, WebSocketChannel webSocketChannel) {
        if (this.requiresAuthentication) {
            String string = null;
            if (webSocketHttpExchange.getRequestHeader("Cookie") != null) {
                string = webSocketHttpExchange.getRequestHeader("Cookie");
            }
            if (RequestUtils.hasValidAuthentication(string)) {
                webSocketChannel.getReceiveSetter().set((ChannelListener)Application.getInstance(this.controllerClass));
                webSocketChannel.resumeReceives();
                webSocketChannel.addCloseTask((ChannelListener)Application.getInstance(WebSocketCloseListener.class));
                Application.getInstance(WebSocketManager.class).addChannel(webSocketChannel);
            } else {
                IOUtils.closeQuietly((Closeable)webSocketChannel);
            }
        } else {
            webSocketChannel.getReceiveSetter().set((ChannelListener)Application.getInstance(this.controllerClass));
            webSocketChannel.resumeReceives();
            webSocketChannel.addCloseTask((ChannelListener)Application.getInstance(WebSocketCloseListener.class));
            Application.getInstance(WebSocketManager.class).addChannel(webSocketChannel);
        }
    }
}

