/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.listeners;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.models.Metrics;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Singleton
public class MetricsListener
implements ResponseCommitListener {
    private final Metrics metrics;
    private final List<String> blacklist = Arrays.asList("@cache", "@metrics", "@config", "@routes", "@health", "@scheduler", "@memory", "@system");

    @Inject
    public MetricsListener(Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics can not be null");
    }

    public void beforeCommit(HttpServerExchange httpServerExchange) {
        String string = Optional.ofNullable(httpServerExchange.getRequestURI()).orElse("").replace("/", "").toLowerCase();
        if (!this.blacklist.contains(string)) {
            this.metrics.inc(httpServerExchange.getStatusCode());
        }
    }
}

