/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.listeners;

import com.google.inject.Inject;
import io.mangoo.cache.Cache;
import io.mangoo.enums.Default;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Singleton;
import org.xnio.ChannelListener;

@Singleton
public class ServerSentEventCloseListener
implements ChannelListener<ServerSentEventConnection> {
    private final Cache cache;

    @Inject
    public ServerSentEventCloseListener(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "cache can not be null");
    }

    public void handleEvent(ServerSentEventConnection serverSentEventConnection) {
        String string = RequestUtils.getServerSentEventURL(serverSentEventConnection);
        Set set = (Set)this.cache.get(Default.SSE_CACHE_PREFIX.toString() + string);
        if (set != null) {
            set.remove(serverSentEventConnection);
            this.cache.put(Default.SSE_CACHE_PREFIX.toString() + string, set);
        }
    }
}

