/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.listeners;

import com.google.inject.Inject;
import io.mangoo.cache.Cache;
import io.mangoo.enums.Default;
import io.mangoo.utils.RequestUtils;
import io.undertow.websockets.core.WebSocketChannel;
import java.util.Objects;
import java.util.Set;
import javax.inject.Singleton;
import org.xnio.ChannelListener;

@Singleton
public class WebSocketCloseListener
implements ChannelListener<WebSocketChannel> {
    private final Cache cache;

    @Inject
    public WebSocketCloseListener(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "cache can not be null");
    }

    public void handleEvent(WebSocketChannel webSocketChannel) {
        String string = RequestUtils.getWebSocketURL(webSocketChannel);
        Set set = (Set)this.cache.get(Default.WSS_CACHE_PREFIX.toString() + string);
        if (set != null) {
            set.remove(webSocketChannel);
            this.cache.put(Default.WSS_CACHE_PREFIX.toString() + string, set);
        }
    }
}

