/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.scheduler;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.scheduler.SchedulerFactory;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;

@Singleton
public class Scheduler {
    private static final Config CONFIG = Application.getConfig();
    private static final Logger LOG = LogManager.getLogger(Scheduler.class);
    private org.quartz.Scheduler quartzScheduler;

    public Scheduler() {
        CONFIG.getAllConfigurations().entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith(Default.SCHEDULER_PREFIX.toString())) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        });
    }

    public org.quartz.Scheduler getScheduler() {
        return this.quartzScheduler;
    }

    public void start() {
        this.initialize();
        try {
            this.quartzScheduler.start();
            if (this.quartzScheduler.isStarted()) {
                LOG.info("Successfully started quartz scheduler");
            } else {
                LOG.error("Scheduler is not started");
            }
        }
        catch (SchedulerException schedulerException) {
            LOG.error("Failed to start scheduler", (Throwable)schedulerException);
        }
    }

    public void shutdown() {
        Objects.requireNonNull(this.quartzScheduler, "Scheduler is not initialized or started");
        try {
            this.quartzScheduler.shutdown();
            if (this.quartzScheduler.isShutdown()) {
                LOG.info("Successfully shutdown quartz scheduler");
            } else {
                LOG.error("Failed to shutdown scheduler");
            }
        }
        catch (SchedulerException schedulerException) {
            LOG.error("Failed to shutdown scheduler", (Throwable)schedulerException);
        }
    }

    public void standby() {
        Objects.requireNonNull(this.quartzScheduler, "Scheduler is not initialized or started");
        try {
            this.quartzScheduler.standby();
            if (this.quartzScheduler.isInStandbyMode()) {
                LOG.info("Scheduler is now in standby");
            } else {
                LOG.error("Failed to put scheduler in standby");
            }
        }
        catch (SchedulerException schedulerException) {
            LOG.error("Failed to put scheduler in standby", (Throwable)schedulerException);
        }
    }

    private void initialize() {
        if (this.quartzScheduler == null) {
            try {
                this.quartzScheduler = new StdSchedulerFactory().getScheduler();
                this.quartzScheduler.setJobFactory((JobFactory)Application.getInstance(SchedulerFactory.class));
            }
            catch (SchedulerException schedulerException) {
                LOG.error("Failed to initialize scheduler", (Throwable)schedulerException);
            }
        }
    }

    public void schedule(JobDetail jobDetail, Trigger trigger) {
        Objects.requireNonNull(jobDetail, "JobDetail is required for schedule");
        Objects.requireNonNull(trigger, "trigger is required for schedule");
        this.initialize();
        try {
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            LOG.error("Failed to schedule a new job", (Throwable)schedulerException);
        }
    }

    @Deprecated
    public Trigger createTrigger(String string, String string2, String string3, String string4) {
        Objects.requireNonNull(string, "Identity is required for creating a new trigger");
        Objects.requireNonNull(string2, "groupName is required for new trigger");
        Objects.requireNonNull(string4, "cron is required for new trigger");
        Preconditions.checkArgument((boolean)CronExpression.isValidExpression((String)string4), (Object)"cron expression is invalid");
        return TriggerBuilder.newTrigger().withIdentity(string, string2).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string4)).withDescription(string3).build();
    }

    @Deprecated
    public JobDetail createJobDetail(String string, String string2, Class<? extends Job> clazz) {
        Objects.requireNonNull(string, "identity is required for new JobDetail");
        Objects.requireNonNull(string2, "groupName is required for new JobDetail");
        Objects.requireNonNull(clazz, "clazz is required for new JobDetail");
        return JobBuilder.newJob(clazz).withIdentity(string, string2).build();
    }
}

