/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating;

import com.google.common.base.Charsets;
import com.google.inject.Singleton;
import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.i18n.Messages;
import io.mangoo.models.Source;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.templating.TemplateEngineLoader;
import io.mangoo.templating.directives.AuthenticityFormDirective;
import io.mangoo.templating.directives.AuthenticityTokenDirective;
import io.mangoo.templating.methods.I18nMethod;
import io.mangoo.utils.RequestUtils;
import io.mangoo.utils.ThrowableUtils;
import io.undertow.server.HttpServerExchange;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Singleton
public class TemplateEngine {
    private final Configuration configuration = new Configuration(VERSION);
    private final String baseDirectory;
    private static final int MAX_CHARS = 65536;
    private static final int ONE_SECOND_MS = 1000;
    private static final int STRONG_SIZE_LIMIT = 20;
    private static final Version VERSION = new Version(2, 3, 23);

    public TemplateEngine() {
        this.configuration.setClassForTemplateLoading(this.getClass(), Default.TEMPLATES_FOLDER.toString());
        this.configuration.setDefaultEncoding(Charsets.UTF_8.name());
        this.configuration.setOutputEncoding(Charsets.UTF_8.name());
        this.configuration.setLocalizedLookup(false);
        this.configuration.setNumberFormat(Default.NUMBER_FORMAT.toString());
        this.configuration.setTemplateLoader((TemplateLoader)new TemplateEngineLoader(this.configuration.getTemplateLoader()));
        this.configuration.setAPIBuiltinEnabled(true);
        if (Application.inDevMode()) {
            this.configuration.setTemplateUpdateDelayMilliseconds(1000L);
        } else {
            this.configuration.setTemplateUpdateDelayMilliseconds(Integer.MAX_VALUE);
            this.configuration.setCacheStorage((CacheStorage)new MruCacheStorage(20, Integer.MAX_VALUE));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("user.dir")).append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java");
        this.baseDirectory = stringBuilder.toString();
    }

    public String render(Flash flash, Session session, Form form, Messages messages, String string, Map<String, Object> map) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template template = this.configuration.getTemplate(string);
        map.put("form", form);
        map.put("flash", flash);
        map.put("session", session);
        map.put("i18n", new I18nMethod(messages));
        map.put("authenticityToken", new AuthenticityTokenDirective(session));
        map.put("authenticityForm", new AuthenticityFormDirective(session));
        return this.processTemplate(map, template);
    }

    public String render(String string, String string2, Map<String, Object> map) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template template = this.configuration.getTemplate(string + "/" + RequestUtils.getTemplateName(string2));
        return this.processTemplate(map, template);
    }

    public String renderException(HttpServerExchange httpServerExchange, Throwable throwable, boolean bl) throws FileNotFoundException, IOException, TemplateException {
        String string;
        StackTraceElement stackTraceElement;
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("templateException", bl);
        if (bl) {
            hashMap.put("exceptions", throwable.getMessage().split("\n"));
        } else {
            stackTraceElement = Arrays.asList(throwable.getStackTrace()).get(0);
            string = ThrowableUtils.getSourceCodePath(stackTraceElement);
            List<Source> list = ThrowableUtils.getSources(stackTraceElement.getLineNumber(), string);
            hashMap.put("sources", list);
            hashMap.put("cause", ExceptionUtils.getMessage((Throwable)throwable));
            hashMap.put("url", httpServerExchange.getRequestURI());
            hashMap.put("method", httpServerExchange.getRequestMethod());
            hashMap.put("line", stackTraceElement.getLineNumber());
            hashMap.put("causeSource", throwable.toString());
            hashMap.put("stackTraces", throwable.getStackTrace());
            hashMap.put("sourceCodePath", StringUtils.substringAfter((String)new File(this.baseDirectory).toPath().resolve(string).toFile().getPath(), (String)"src/main/java") + " around line " + stackTraceElement.getLineNumber());
        }
        stackTraceElement = new Configuration(VERSION);
        stackTraceElement.setClassForTemplateLoading(this.getClass(), Default.DEFAULT_TEMPLATES_DIR.toString());
        string = stackTraceElement.getTemplate(Default.EXCEPTION_TEMPLATE_NAME.toString());
        string.process(hashMap, (Writer)stringWriter);
        return ((Object)stringWriter).toString();
    }

    private String processTemplate(Map<String, Object> map, Template template) throws TemplateException, IOException {
        StringWriter stringWriter = new StringWriter(65536);
        template.process(map, (Writer)stringWriter);
        return stringWriter.toString();
    }
}

