/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.io.Resources;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.RouteType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BootstrapUtils {
    private static final Logger LOG = LogManager.getLogger(BootstrapUtils.class);

    private BootstrapUtils() {
    }

    public static RouteType getRouteType(String string) {
        Objects.requireNonNull(string, "method can not be null");
        switch (string.toUpperCase(Locale.ENGLISH)) {
            case "GET": 
            case "POST": 
            case "PUT": 
            case "DELETE": 
            case "HEAD": {
                return RouteType.REQUEST;
            }
            case "WSS": {
                return RouteType.WEBSOCKET;
            }
            case "SSE": {
                return RouteType.SERVER_SENT_EVENT;
            }
            case "FILE": {
                return RouteType.RESOURCE_FILE;
            }
            case "PATH": {
                return RouteType.RESOURCE_PATH;
            }
        }
        return null;
    }

    public static boolean hasBlocking(String string) {
        return StringUtils.isNotBlank((CharSequence)string) && string.toLowerCase(Locale.ENGLISH).contains(Default.BLOCKING.toString());
    }

    public static boolean hasAuthentication(String string) {
        return StringUtils.isNotBlank((CharSequence)string) && string.toLowerCase(Locale.ENGLISH).contains(Default.AUTHENTICATION.toString());
    }

    public static String getVersion() {
        String string = Default.VERSION.toString();
        try (InputStream inputStream = Resources.getResource((String)Default.VERSION_PROPERTIES.toString()).openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            string = String.valueOf(properties.get(Key.VERSION.toString()));
        }
        catch (IOException iOException) {
            LOG.error("Failed to get application version", (Throwable)iOException);
        }
        return string;
    }

    public static String getLogo() {
        String string = "";
        try (InputStream inputStream = Resources.getResource((String)Default.LOGO_FILE.toString()).openStream();){
            string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException iOException) {
            LOG.error("Failed to get application logo", (Throwable)iOException);
        }
        return string;
    }
}

