/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class CookieBuilder {
    private String cookieName = "";
    private String cookieValue = "";
    private String cookiePath = "/";
    private String cookieDomain;
    private Integer cookieMaxAge;
    private LocalDateTime cookieExpires = LocalDateTime.now().plusDays(1L);
    private boolean cookieDiscard;
    private boolean cookieSecure;
    private boolean cookieHttpOnly;

    public static CookieBuilder create() {
        return new CookieBuilder();
    }

    public CookieBuilder name(String string) {
        this.cookieName = string;
        return this;
    }

    public CookieBuilder value(String string) {
        this.cookieValue = string;
        return this;
    }

    public CookieBuilder path(String string) {
        this.cookiePath = string;
        return this;
    }

    public CookieBuilder expires(LocalDateTime localDateTime) {
        this.cookieExpires = localDateTime;
        return this;
    }

    public CookieBuilder maxAge(Integer n) {
        this.cookieMaxAge = n;
        return this;
    }

    public CookieBuilder domain(String string) {
        this.cookieDomain = string;
        return this;
    }

    public CookieBuilder discard(boolean bl) {
        this.cookieDiscard = bl;
        return this;
    }

    public CookieBuilder secure(boolean bl) {
        this.cookieSecure = bl;
        return this;
    }

    public CookieBuilder httpOnly(boolean bl) {
        this.cookieHttpOnly = bl;
        return this;
    }

    public Cookie build() {
        CookieImpl cookieImpl = new CookieImpl(this.cookieName).setValue(this.cookieValue).setDiscard(this.cookieDiscard).setSecure(this.cookieSecure).setHttpOnly(this.cookieHttpOnly).setPath(this.cookiePath).setExpires(this.cookieExpires == null ? Date.from(LocalDateTime.now().plusDays(1L).atZone(ZoneId.systemDefault()).toInstant()) : Date.from(this.cookieExpires.atZone(ZoneId.systemDefault()).toInstant()));
        if (this.cookieDomain != null) {
            cookieImpl.setDomain(this.cookieDomain);
        }
        if (this.cookieMaxAge != null) {
            cookieImpl.setMaxAge(this.cookieMaxAge);
        }
        return cookieImpl;
    }
}

