/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Splitter;
import io.mangoo.core.Application;
import io.mangoo.crypto.Crypto;
import io.mangoo.enums.Default;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class CookieParser {
    private static final int AUTH_PREFIX_LENGTH = 3;
    private static final int SESSION_PREFIX_LENGTH = 4;
    private static final int INDEX_0 = 0;
    private static final int INDEX_1 = 1;
    private static final int INDEX_2 = 2;
    private static final int INDEX_3 = 3;
    private final Map<String, String> sessionValues = new HashMap<String, String>();
    private final boolean encrypted;
    private final String secret;
    private String value;
    private String sign;
    private String expires;
    private String authenticityToken;
    private String authenticatedUser;
    private String version;
    private LocalDateTime expiresDate;

    public CookieParser(String string, String string2, boolean bl) {
        this.value = string;
        this.encrypted = bl;
        this.secret = string2;
    }

    public static CookieParser create(HttpServerExchange httpServerExchange, String string, String string2, boolean bl) {
        Objects.requireNonNull(httpServerExchange, "exchange can not be null");
        Objects.requireNonNull(string, "cookieName can not be null");
        Objects.requireNonNull(string2, "application secret can not be null");
        return new CookieParser(CookieParser.getCookieValue(httpServerExchange, string), string2, bl);
    }

    public boolean hasValidSessionCookie() {
        this.decrypt();
        this.extractSession();
        boolean bl = false;
        if (StringUtils.isNotBlank((CharSequence)this.sign) && StringUtils.isNotBlank((CharSequence)this.expires) && StringUtils.isNotBlank((CharSequence)this.authenticityToken)) {
            String string = this.value.substring(this.value.indexOf(Default.DATA_DELIMITER.toString()) + 1, this.value.length());
            LocalDateTime localDateTime = LocalDateTime.parse(this.expires);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(this.authenticityToken).append(this.expires).append(this.version).append(this.secret);
            if (LocalDateTime.now().isBefore(localDateTime) && DigestUtils.sha512Hex((String)stringBuilder.toString()).equals(this.sign)) {
                this.expiresDate = localDateTime;
                bl = true;
                if (StringUtils.isNotEmpty((CharSequence)string)) {
                    Splitter.on((String)Default.SPLITTER.toString()).withKeyValueSeparator(Default.SEPERATOR.toString()).split((CharSequence)string).entrySet().forEach(entry -> this.sessionValues.put((String)entry.getKey(), (String)entry.getValue()));
                }
            }
        }
        return bl;
    }

    public boolean hasValidAuthenticationCookie() {
        this.decrypt();
        this.extractAuthentication();
        boolean bl = false;
        if (StringUtils.isNotBlank((CharSequence)this.sign) && StringUtils.isNotBlank((CharSequence)this.expires)) {
            String string = this.value.substring(this.value.indexOf(Default.DATA_DELIMITER.toString()) + 1, this.value.length());
            LocalDateTime localDateTime = LocalDateTime.parse(this.expires);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(this.expires).append(this.version).append(this.secret);
            if (LocalDateTime.now().isBefore(localDateTime) && DigestUtils.sha512Hex((String)stringBuilder.toString()).equals(this.sign)) {
                this.expiresDate = localDateTime;
                this.authenticatedUser = string;
                bl = true;
            }
        }
        return bl;
    }

    private void extractSession() {
        String[] stringArray;
        String string = StringUtils.substringBefore((String)this.value, (String)Default.DATA_DELIMITER.toString());
        if (StringUtils.isNotBlank((CharSequence)string) && (stringArray = string.split("\\" + Default.DELIMITER.toString())) != null && stringArray.length == 4) {
            this.sign = stringArray[0];
            this.authenticityToken = stringArray[1];
            this.expires = stringArray[2];
            this.version = stringArray[3];
        }
    }

    private void extractAuthentication() {
        String[] stringArray;
        String string = StringUtils.substringBefore((String)this.value, (String)Default.DATA_DELIMITER.toString());
        if (StringUtils.isNotBlank((CharSequence)string) && (stringArray = string.split("\\" + Default.DELIMITER.toString())) != null && stringArray.length == 3) {
            this.sign = stringArray[0];
            this.expires = stringArray[1];
            this.version = stringArray[2];
        }
    }

    private static String getCookieValue(HttpServerExchange httpServerExchange, String string) {
        String string2 = null;
        Cookie cookie = (Cookie)httpServerExchange.getRequestCookies().get(string);
        if (cookie != null) {
            string2 = cookie.getValue();
        }
        return string2;
    }

    public Map<String, String> getSessionValues() {
        return this.sessionValues;
    }

    public String getAuthenticityToken() {
        return this.authenticityToken;
    }

    public LocalDateTime getExpiresDate() {
        return this.expiresDate;
    }

    public String getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    private void decrypt() {
        if (this.encrypted && !this.value.contains("\\|")) {
            this.value = Application.getInstance(Crypto.class).decrypt(this.value);
        }
    }
}

