/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.advantageous.boon.json.JsonFactory;
import io.advantageous.boon.json.JsonSerializer;
import io.advantageous.boon.json.JsonSerializerFactory;
import io.advantageous.boon.json.ObjectMapper;
import java.util.Objects;

public final class JsonUtils {
    private static volatile JsonSerializer jsonSerializer = JsonUtils.createJsonSerializer();
    private static ObjectMapper objectMapper = JsonFactory.create();

    private JsonUtils() {
    }

    private static JsonSerializer createJsonSerializer() {
        JsonSerializerFactory jsonSerializerFactory = new JsonSerializerFactory();
        jsonSerializerFactory.useAnnotations();
        return jsonSerializerFactory.create();
    }

    public static void withJsonSerializer(JsonSerializer jsonSerializer) {
        JsonUtils.jsonSerializer = jsonSerializer;
    }

    public static String toJson(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        return jsonSerializer.serialize(object).toString();
    }

    public static Object fromJson(String string) {
        Objects.requireNonNull(string, "json can not be null");
        return objectMapper.fromJson(string);
    }

    public static <T> T fromJson(String string, Class<T> clazz) {
        Objects.requireNonNull(string, "json can not be null");
        Objects.requireNonNull(clazz, "clazz can not be null");
        return (T)objectMapper.fromJson(string, clazz);
    }
}

