/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Charsets;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import io.mangoo.configuration.Config;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Mode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public final class MinificationUtils {
    private static final Logger LOG = LogManager.getLogger(MinificationUtils.class);
    private static final int HUNDRET_PERCENT = 100;
    private static String basePath;
    private static volatile Config config;
    private static final String JS = "js";
    private static final String CSS = "css";
    private static final String MIN = "min";
    private static final boolean DISABLEOPTIMIZATION = false;
    private static final boolean PRESERVESEMICOLONS = false;
    private static final boolean VERBOSE = false;
    private static final boolean MUNGE = true;
    private static final int LINEBREAK = -1;

    private MinificationUtils() {
        config = new Config(basePath + Default.CONFIG_PATH.toString(), Mode.DEV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBasePath(String string) {
        Class<MinificationUtils> clazz = MinificationUtils.class;
        synchronized (MinificationUtils.class) {
            basePath = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void minify(String string) {
        if (string == null || string.contains(MIN)) {
            return;
        }
        if (config == null) {
            System.setProperty(Key.APPLICATION_CONFIG.toString(), basePath + Default.CONFIG_PATH.toString());
            config = new Config(basePath + Default.CONFIG_PATH.toString(), Mode.DEV);
        }
        if (config.getBoolean(Key.APPLICATION_MINIFY_JS.toString(), false) && string.endsWith(JS)) {
            MinificationUtils.minifyJS(new File(string));
        } else if (config.getBoolean(Key.APPLICATION_MINIFY_CSS.toString(), false) && string.endsWith(CSS)) {
            MinificationUtils.minifyCSS(new File(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void minifyJS(File file) {
        block6: {
            InputStreamReader inputStreamReader = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file2 = MinificationUtils.getOutputFile(file, JS);
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), Charsets.UTF_8);
                JavaScriptCompressor javaScriptCompressor = new JavaScriptCompressor((Reader)inputStreamReader, (ErrorReporter)new MinificationErrorReporter());
                javaScriptCompressor.compress((Writer)outputStreamWriter, -1, true, false, false, false);
                outputStreamWriter.flush();
                MinificationUtils.logMinification(file, file2);
                if (config.getBoolean(Key.APPLICATION_GZIP_JS.toString(), false)) {
                    MinificationUtils.createGzipFile(file2);
                }
                IOUtils.closeQuietly((Reader)inputStreamReader);
            }
            catch (IOException iOException) {
                LOG.error("Failed to minify JS", (Throwable)iOException);
                break block6;
            }
            finally {
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(outputStreamWriter);
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
        }
    }

    private static void logMinification(File file, File file2) {
        LOG.info(String.format("Minified asset %s (%db) -> %s (%db) [compressed to %d%% of original size]", file.getName(), file.length(), file2.getName(), file2.length(), MinificationUtils.ratioOfSize(file, file2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void minifyCSS(File file) {
        block6: {
            InputStreamReader inputStreamReader = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file2 = MinificationUtils.getOutputFile(file, CSS);
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), Charsets.UTF_8);
                CssCompressor cssCompressor = new CssCompressor((Reader)inputStreamReader);
                cssCompressor.compress((Writer)outputStreamWriter, -1);
                outputStreamWriter.flush();
                MinificationUtils.logMinification(file, file2);
                if (config.getBoolean(Key.APPLICATION_GZIP_CSS.toString(), false)) {
                    MinificationUtils.createGzipFile(file2);
                }
                IOUtils.closeQuietly((Reader)inputStreamReader);
            }
            catch (IOException iOException) {
                LOG.error("Failed to minify CSS", (Throwable)iOException);
                break block6;
            }
            finally {
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(outputStreamWriter);
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
        }
    }

    private static File getOutputFile(File file, String string) {
        String string2 = file.getAbsolutePath().split("target")[0];
        String string3 = file.getName();
        string3 = string3.substring(0, string3.lastIndexOf(46));
        String string4 = null;
        if (CSS.equals(string)) {
            string4 = config.getString(Key.APPLICATION_MINIFY_CSSFOLDER, Default.STYLESHEET_FOLDER.toString());
        } else if (JS.equals(string)) {
            string4 = config.getString(Key.APPLICATION_MINIFY_JSFOLDER, Default.JAVSCRIPT_FOLDER.toString());
        }
        return new File(string2 + Default.ASSETS_PATH.toString() + "/" + string4 + "/" + string3 + ".min." + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createGzipFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File file2 = new File(file.getAbsolutePath() + ".gz");
        GZIPOutputStream gZIPOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file2));
            fileInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)gZIPOutputStream);
            LOG.info("Created gzipped asset " + file2.getName());
        }
        catch (IOException iOException) {
            try {
                LOG.error("Failed to create gzipped file", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gZIPOutputStream);
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)gZIPOutputStream);
            IOUtils.closeQuietly(fileInputStream);
        }
        IOUtils.closeQuietly((OutputStream)gZIPOutputStream);
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    private static long ratioOfSize(File file, File file2) {
        long l = Math.max(file.length(), 1L);
        long l2 = Math.max(file2.length(), 1L);
        return l2 * 100L / l;
    }

    private static class MinificationErrorReporter
    implements ErrorReporter {
        private MinificationErrorReporter() {
        }

        public void warning(String string, String string2, int n, String string3, int n2) {
            if (n < 0) {
                LOG.warn(string);
            } else {
                LOG.warn(n + 58 + n2 + 58 + string);
            }
        }

        public void error(String string, String string2, int n, String string3, int n2) {
            if (n < 0) {
                LOG.error(string);
            } else {
                LOG.error(n + 58 + n2 + 58 + string);
            }
        }

        public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
            this.error(string, string2, n, string3, n2);
            return new EvaluatorException(string);
        }
    }
}

