/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Charsets;
import io.mangoo.models.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public final class ThrowableUtils {
    private ThrowableUtils() {
    }

    public static String getSourceCodePath(StackTraceElement stackTraceElement) {
        Objects.requireNonNull(stackTraceElement, "stackTraceElement can not be null");
        String string = stackTraceElement.getClassName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
            return string.replace(".", File.separator) + File.separator + stackTraceElement.getFileName();
        }
        return stackTraceElement.getFileName();
    }

    public static List<Source> getSources(int n, String string) throws FileNotFoundException, IOException {
        Objects.requireNonNull("sourcePath", "sourcePath can not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("user.dir")).append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java");
        ArrayList<Source> arrayList = new ArrayList<Source>();
        File file = new File(stringBuilder.toString()).toPath().resolve(string).toFile();
        if (file.exists()) {
            List list = IOUtils.readLines((InputStream)new FileInputStream(file), (Charset)Charsets.UTF_8);
            int n2 = 0;
            for (String string2 : list) {
                if (n2 + 8 > n && n2 - 6 < n) {
                    arrayList.add(new Source(n2 + 1 == n, n2 + 1, string2));
                }
                ++n2;
            }
        }
        return arrayList;
    }
}

