/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.mangoo.cache.Cache;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TwoFactorUtils {
    private static final Logger LOG = LogManager.getLogger(Cache.class);
    private static final Base32 base32 = new Base32();
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String BLOCK_OF_ZEROS = "000000";
    private static final int TIME_STEP_SECONDS = 30;
    private static final boolean USE_SHA1_THREAD_LOCAL = true;
    private static final ThreadLocal<Mac> MAC_THREAD_LOCAL = new ThreadLocal<Mac>(){

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(TwoFactorUtils.HMAC_SHA1);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Unknown message authentication code instance: HmacSHA1", noSuchAlgorithmException);
            }
        }
    };

    public static String generateBase32Secret() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int n = secureRandom.nextInt(32);
            if (n < 26) {
                stringBuilder.append((char)(65 + n));
                continue;
            }
            stringBuilder.append((char)(50 + (n - 26)));
        }
        return stringBuilder.toString();
    }

    public static String generateCurrentNumber(String string) {
        return TwoFactorUtils.generateCurrentNumber(string, System.currentTimeMillis());
    }

    private static String generateCurrentNumber(String string, long l) {
        Objects.requireNonNull(string, "secret can not be null");
        byte[] byArray = base32.decode(string.getBytes());
        byte[] byArray2 = new byte[8];
        long l2 = l / 1000L / 30L;
        int n = 7;
        while (l2 > 0L) {
            byArray2[n] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
            --n;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, HMAC_SHA1);
        byte[] byArray3 = null;
        try {
            Mac mac = MAC_THREAD_LOCAL.get();
            mac.init(secretKeySpec);
            byArray3 = mac.doFinal(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error("Failed to encrypt data with key", (Throwable)generalSecurityException);
        }
        int n2 = byArray3[byArray3.length - 1] & 0xF;
        long l3 = 0L;
        for (int i = n2; i < n2 + 4; ++i) {
            l3 <<= 8;
            l3 |= (long)(byArray3[i] & 0xFF);
        }
        l3 &= Integer.MAX_VALUE;
        return TwoFactorUtils.zeroPrepend(l3 %= 1000000L, 0);
    }

    public String getQRCode(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("https://chart.googleapis.com/chart").append("?chs=200x200&cht=qr&chl=200x200&chld=M|0&cht=qr&chl=").append("otpauth://totp/").append(string).append("?secret=").append(string2);
        return stringBuilder.toString();
    }

    private static String zeroPrepend(long l, int n) {
        String string = Long.toString(l);
        if (string.length() >= n) {
            return string;
        }
        int n2 = n - string.length();
        StringBuilder stringBuilder = new StringBuilder(n).append(BLOCK_OF_ZEROS, 0, n2).append(string);
        return stringBuilder.toString();
    }
}

