/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import com.google.inject.Inject;
import io.mangoo.admin.AdminFilter;
import io.mangoo.annotations.FilterWith;
import io.mangoo.cache.Cache;
import io.mangoo.core.Application;
import io.mangoo.enums.Template;
import io.mangoo.exceptions.MangooSchedulerException;
import io.mangoo.models.Metrics;
import io.mangoo.routing.Response;
import io.mangoo.routing.Router;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.utils.BootstrapUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ocpsoft.prettytime.PrettyTime;

@FilterWith(value={AdminFilter.class})
public class AdminController {
    private static final Logger LOG = LogManager.getLogger(AdminController.class);
    private static final String SCHEDULER = "scheduler";
    private static final String METRICS = "metrics";
    private static final String CACHE = "cache";
    private static final String ROUTES = "routes";
    private static final String JOBS = "jobs";
    private static final String STATS = "stats";
    private static final String SPACE = "space";
    private static final String VERSION = "version";
    private static final int MB = 0x100000;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Scheduler scheduler;

    @Inject
    public AdminController(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler can not be null");
        System.getProperties().entrySet().forEach(entry -> this.properties.put(entry.getKey().toString(), entry.getValue().toString()));
    }

    public Response index() {
        Runtime runtime = Runtime.getRuntime();
        double d = runtime.maxMemory() / 0x100000L;
        Instant instant = Application.getStart().atZone(ZoneId.systemDefault()).toInstant();
        PrettyTime prettyTime = new PrettyTime(Locale.ENGLISH);
        return Response.withOk().andContent(VERSION, BootstrapUtils.getVersion()).andContent(SPACE, null).andContent("uptime", prettyTime.format(Date.from(instant))).andContent("started", Application.getStart()).andContent("properties", this.properties).andContent("maxMemory", d).andTemplate(Template.DEFAULT.adminPath());
    }

    public Response execute(String string) {
        try {
            this.scheduler.executeJob(string);
        }
        catch (MangooSchedulerException mangooSchedulerException) {
            LOG.error("Failed to execute job with name: " + string, (Throwable)mangooSchedulerException);
        }
        return Response.withRedirect("/@admin/scheduler");
    }

    public Response state(String string) {
        try {
            this.scheduler.changeState(string);
        }
        catch (MangooSchedulerException mangooSchedulerException) {
            LOG.error("Failed to change the state of job with name: " + string, (Throwable)mangooSchedulerException);
        }
        return Response.withRedirect("/@admin/scheduler");
    }

    public Response routes() {
        return Response.withOk().andContent(SPACE, ROUTES).andContent(VERSION, BootstrapUtils.getVersion()).andContent(ROUTES, Router.getRoutes()).andTemplate(Template.DEFAULT.routesPath());
    }

    public Response cache() {
        return Response.withOk().andContent(SPACE, CACHE).andContent(VERSION, BootstrapUtils.getVersion()).andContent(STATS, Application.getInstance(Cache.class).getStats()).andTemplate(Template.DEFAULT.cachePath());
    }

    public Response metrics() {
        Metrics metrics = Application.getInstance(Metrics.class);
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        for (Map.Entry<Integer, LongAdder> entry : metrics.getMetrics().entrySet()) {
            if (String.valueOf(entry.getKey()).charAt(0) == '5') {
                l2 += entry.getValue().longValue();
            }
            l += entry.getValue().longValue();
        }
        if (l2 > 0L) {
            d = l / l2;
        }
        return Response.withOk().andContent(SPACE, METRICS).andContent(VERSION, BootstrapUtils.getVersion()).andContent(METRICS, metrics.getMetrics()).andContent("totalRequests", l).andContent("minRequestTime", metrics.getMinRequestTime()).andContent("avgRequestTime", metrics.getAvgRequestTime()).andContent("maxRequestTime", metrics.getMaxRequestTime()).andContent("errorRate", d).andTemplate(Template.DEFAULT.metricsPath());
    }

    public Response scheduler() {
        List<Object> list = new ArrayList();
        if (this.scheduler.isInitialize()) {
            try {
                list = this.scheduler.getAllJobs();
            }
            catch (MangooSchedulerException mangooSchedulerException) {
                LOG.error("Failed to retrieve jobs from scheduler", (Throwable)mangooSchedulerException);
            }
        }
        return Response.withOk().andContent(SPACE, SCHEDULER).andContent(VERSION, BootstrapUtils.getVersion()).andContent(JOBS, list).andTemplate(Template.DEFAULT.schedulerPath());
    }
}

