/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import com.google.common.base.Charsets;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Template;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.undertow.util.Headers;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class AdminFilter
implements MangooFilter {
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private static final Config CONFIG = Application.getConfig();

    @Override
    public Response execute(Request request, Response response) {
        if (!CONFIG.isAdminEnabled()) {
            return Response.withNotFound().andBody(Template.DEFAULT.notFound()).end();
        }
        if (!this.isAuthenticated(request)) {
            return Response.withUnauthorized().andHeader(Headers.WWW_AUTHENTICATE, "Basic realm=Administration authentication").andEmptyBody().end();
        }
        return response;
    }

    private boolean isAuthenticated(Request request) {
        String string = null;
        String string2 = null;
        String string3 = request.getHeader(Headers.AUTHORIZATION);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            string3 = string3.replace("Basic", "");
            string3 = string3.trim();
            String[] stringArray = (string3 = new String(base64Decoder.decode(string3), Charsets.UTF_8)).split(":");
            if (stringArray != null && stringArray.length == Default.BASICAUTH_CREDENTIALS_LENGTH.toInt()) {
                string = stringArray[0];
                string2 = stringArray[1];
            }
        }
        return StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string2) && StringUtils.isNotBlank((CharSequence)CONFIG.getAdminAuthenticationUser()) && StringUtils.isNotBlank((CharSequence)CONFIG.getAdminAuthenticationPassword()) && CONFIG.getAdminAuthenticationUser().equals(string) && CONFIG.getAdminAuthenticationPassword().equals(DigestUtils.sha512Hex(string2));
    }
}

