/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.inject.Singleton;
import io.mangoo.cache.Cache;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class GuavaCache
implements Cache {
    private static final Config CONFIG = Application.getConfig();
    private final com.google.common.cache.Cache<String, Object> cache;

    public GuavaCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)CONFIG.getInt(Key.CACHE_MAX_SIZE, Default.CACHE_MAX_SIZE.toInt()));
        if (CONFIG.isAdminEnabled()) {
            cacheBuilder.recordStats();
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public void put(String string, Object object) {
        Objects.requireNonNull(string, Default.KEY_REQUIRED.toString());
        Objects.requireNonNull(object, Default.VALUE_REQUIRED.toString());
        this.cache.put((Object)string, object);
    }

    @Override
    public void remove(String string) {
        Objects.requireNonNull(string, Default.KEY_REQUIRED.toString());
        this.cache.invalidate((Object)string);
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public <T> T get(String string) {
        Objects.requireNonNull(string, Default.KEY_REQUIRED.toString());
        Object object = this.cache.getIfPresent((Object)string);
        return (T)(object == null ? null : object);
    }

    @Override
    public void putAll(Map<String, Object> map) {
        Objects.requireNonNull(map, "map can not be null");
        this.cache.putAll(map);
    }

    @Override
    public ConcurrentMap<String, Object> getAll() {
        return this.cache.asMap();
    }

    @Override
    public Map<String, Object> getStats() {
        CacheStats cacheStats = this.cache.stats();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Average load penalty", cacheStats.averageLoadPenalty());
        hashMap.put("Eviction count", cacheStats.evictionCount());
        hashMap.put("Hit count", cacheStats.hitCount());
        hashMap.put("Hit rate", cacheStats.hitRate());
        hashMap.put("Load count", cacheStats.loadCount());
        hashMap.put("Load exception count", cacheStats.loadExceptionCount());
        hashMap.put("Load exception rate", cacheStats.loadExceptionRate());
        hashMap.put("Load success rate", cacheStats.loadSuccessCount());
        hashMap.put("Miss count", cacheStats.missCount());
        hashMap.put("Request count", cacheStats.requestCount());
        hashMap.put("Total load time in ns", cacheStats.totalLoadTime());
        return hashMap;
    }
}

