/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import com.google.inject.Singleton;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.monitor.LocalMapStats;
import io.mangoo.cache.Cache;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class HazlecastCache
implements Cache {
    private static final Config CONFIG = Application.getConfig();
    private final HazelcastInstance cache;

    public HazlecastCache() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{CONFIG.getCacheAddresses()});
        this.cache = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    @Override
    public void put(String string, Object object) {
        Objects.requireNonNull(string, Default.KEY_REQUIRED.toString());
        Objects.requireNonNull(object, Default.VALUE_REQUIRED.toString());
        this.cache.getMap(Default.CACHE_NAME.toString()).put((Object)string, object);
    }

    @Override
    public void remove(String string) {
        Objects.requireNonNull(string, Default.KEY_REQUIRED.toString());
        this.cache.getMap(Default.CACHE_NAME.toString()).remove((Object)string);
    }

    @Override
    public long size() {
        return this.cache.getMap(Default.CACHE_NAME.toString()).size();
    }

    @Override
    public void clear() {
        this.cache.getMap(Default.CACHE_NAME.toString()).clear();
    }

    @Override
    public <T> T get(String string) {
        Objects.requireNonNull(string, Default.KEY_REQUIRED.toString());
        return (T)this.cache.getMap(Default.CACHE_NAME.toString()).get((Object)string);
    }

    @Override
    public void putAll(Map<String, Object> map) {
        Objects.requireNonNull(map, "map can not be null");
        this.cache.getMap(Default.CACHE_NAME.toString()).putAll(map);
    }

    @Override
    public ConcurrentMap<String, Object> getAll() {
        return this.cache.getMap(Default.CACHE_NAME.toString());
    }

    @Override
    public Map<String, Object> getStats() {
        IMap iMap = this.cache.getMap(Default.CACHE_NAME.toString());
        LocalMapStats localMapStats = iMap.getLocalMapStats();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Hits", localMapStats.getHits());
        hashMap.put("Misses", localMapStats.getNearCacheStats().getMisses());
        hashMap.put("Put operation count", localMapStats.getPutOperationCount());
        hashMap.put("Remove operation count", localMapStats.getRemoveOperationCount());
        return hashMap;
    }
}

