/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.Injector;
import io.mangoo.cache.Cache;
import io.mangoo.cache.GuavaCache;
import io.mangoo.cache.HazlecastCache;
import io.mangoo.configuration.Config;
import io.mangoo.core.Bootstrap;
import io.mangoo.enums.Default;
import io.mangoo.enums.Mode;
import io.mangoo.templating.TemplateEngine;
import io.mangoo.templating.freemarker.TemplateEngineFreemarker;
import io.mangoo.utils.BootstrapUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;

public final class Application {
    private static volatile Cache cache;
    private static volatile TemplateEngine templateEngine;
    private static volatile Config config;
    private static volatile Mode mode;
    private static volatile Injector injector;
    private static volatile LocalDateTime start;
    private static volatile boolean started;
    private static volatile String baseDirectory;

    private Application() {
    }

    public static void main(String ... stringArray) {
        Bootstrap bootstrap = new Bootstrap();
        start = bootstrap.getStart();
        mode = bootstrap.prepareMode();
        injector = bootstrap.prepareInjector();
        baseDirectory = BootstrapUtils.getBaseDirectory();
        bootstrap.prepareLogger();
        bootstrap.applicationInitialized();
        bootstrap.prepareConfig();
        bootstrap.parseRoutes();
        bootstrap.startQuartzScheduler();
        bootstrap.startUndertow();
        bootstrap.showLogo();
        bootstrap.applicationStarted();
        if (bootstrap.isBootstrapSuccessful()) {
            Application.getInstance(Config.class).decrypt();
            started = true;
        } else {
            System.out.print("Failed to start mangoo I/O application");
            System.exit(1);
        }
    }

    public static boolean inDevMode() {
        return Mode.DEV.equals((Object)mode);
    }

    public static boolean inProdMode() {
        return Mode.PROD.equals((Object)mode);
    }

    public static boolean inTestMode() {
        return Mode.TEST.equals((Object)mode);
    }

    public static Mode getMode() {
        return mode;
    }

    public static Injector getInjector() {
        return injector;
    }

    public static boolean isStarted() {
        return started;
    }

    public static LocalDateTime getStart() {
        return start;
    }

    public static Config getConfig() {
        Objects.requireNonNull(mode, "cant't create config instance without application mode");
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public static TemplateEngine getInternalTemplateEngine() {
        if (templateEngine == null) {
            templateEngine = new TemplateEngineFreemarker();
        }
        return templateEngine;
    }

    public static Cache getInternalCache() {
        if (cache == null) {
            cache = Default.CACHE_CLASS.toString().equals(config.getCacheClass()) ? new GuavaCache() : new HazlecastCache();
        }
        return cache;
    }

    public static Duration getUptime() {
        Objects.requireNonNull(start, "Can not calculate duration without application start time");
        return Duration.between(start, LocalDateTime.now());
    }

    public static <T> T getInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz can not be null");
        return (T)injector.getInstance(clazz);
    }

    public static String getBaseDirectory() {
        return baseDirectory;
    }
}

