/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.email;

import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.exceptions.MangooMailerException;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.templating.TemplateEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.mail.Authenticator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

public class Mail {
    private static volatile DefaultAuthenticator defaultAuthenticator;
    private final Map<String, Object> content = new HashMap<String, Object>();
    private final List<File> files = new ArrayList<File>();
    private final List<String> recipients = new ArrayList<String>();
    private final List<String> ccRecipients = new ArrayList<String>();
    private final List<String> bccRecipients = new ArrayList<String>();
    private String template;
    private String subject;
    private String from;
    private String body;
    private static volatile String host;
    private static int port;
    private boolean html;
    private boolean attachment;
    private static boolean ssl;

    public static Mail newMail() {
        Config config = Application.getInstance(Config.class);
        host = config.getSmtpHost();
        port = config.getSmtpPort();
        ssl = config.isSmtpSSL();
        String string = config.getSmtpUsername();
        String string2 = config.getSmtpPassword();
        if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2)) {
            defaultAuthenticator = new DefaultAuthenticator(string, string2);
        }
        return new Mail();
    }

    public Mail withRecipient(String string) {
        Objects.requireNonNull(string, "recipient can not be null");
        this.recipients.add(string);
        return this;
    }

    public Mail withCC(String string) {
        Objects.requireNonNull(string, "cc recipient can not be null");
        this.ccRecipients.add(string);
        return this;
    }

    public Mail withSubject(String string) {
        Objects.requireNonNull(string, "subject can not be null");
        this.subject = string;
        return this;
    }

    public Mail withTemplate(String string) {
        Objects.requireNonNull(string, "template can not be null");
        if (string.charAt(0) == '/' || string.startsWith("\\")) {
            string = string.replaceFirst("/", "");
            string = string.replaceFirst("\\", "");
        }
        this.template = string;
        return this;
    }

    public Mail withBCC(String string) {
        Objects.requireNonNull(string, "bcc recipient can not be null");
        this.bccRecipients.add(string);
        return this;
    }

    public Mail withBody(String string) {
        Objects.requireNonNull(string, "body can not be null");
        this.body = string;
        return this;
    }

    public Mail withFrom(String string) {
        Objects.requireNonNull(string, "from can not be null");
        this.from = string;
        return this;
    }

    public Mail withAttachment(File file) {
        Objects.requireNonNull(file, "file can not be null");
        this.attachment = true;
        this.files.add(file);
        return this;
    }

    public Mail isHtml() {
        this.html = true;
        return this;
    }

    public Mail withContent(String string, Object object) {
        Objects.requireNonNull(string, "key can not be null");
        Objects.requireNonNull(object, "value can not be null");
        this.content.put(string, object);
        return this;
    }

    public void send() throws MangooMailerException {
        Config config = Application.getInstance(Config.class);
        if (StringUtils.isBlank((CharSequence)this.from)) {
            this.from = config.getSmtpFrom();
        }
        if (this.html) {
            this.sendHtmlEmail();
        } else if (this.attachment) {
            this.sendMultipartEmail();
        } else {
            this.sendSimpleEmail();
        }
    }

    private void sendSimpleEmail() throws MangooMailerException {
        try {
            SimpleEmail simpleEmail = new SimpleEmail();
            simpleEmail.setHostName(host);
            simpleEmail.setSmtpPort(port);
            simpleEmail.setAuthenticator((Authenticator)defaultAuthenticator);
            simpleEmail.setSSLOnConnect(ssl);
            simpleEmail.setFrom(this.from);
            simpleEmail.setSubject(this.subject);
            simpleEmail.setMsg(this.render());
            for (String string : this.recipients) {
                simpleEmail.addTo(string);
            }
            for (String string : this.ccRecipients) {
                simpleEmail.addCc(string);
            }
            for (String string : this.bccRecipients) {
                simpleEmail.addBcc(string);
            }
            simpleEmail.send();
        }
        catch (MangooTemplateEngineException | EmailException throwable) {
            throw new MangooMailerException((Exception)throwable);
        }
    }

    private void sendMultipartEmail() throws MangooMailerException {
        try {
            MultiPartEmail multiPartEmail = new MultiPartEmail();
            multiPartEmail.setHostName(host);
            multiPartEmail.setSmtpPort(port);
            multiPartEmail.setAuthenticator((Authenticator)defaultAuthenticator);
            multiPartEmail.setSSLOnConnect(ssl);
            multiPartEmail.setFrom(this.from);
            multiPartEmail.setSubject(this.subject);
            multiPartEmail.setMsg(this.render());
            for (String object : this.recipients) {
                multiPartEmail.addTo(object);
            }
            for (String string : this.ccRecipients) {
                multiPartEmail.addCc(string);
            }
            for (String string : this.bccRecipients) {
                multiPartEmail.addBcc(string);
            }
            for (File file : this.files) {
                multiPartEmail.attach(file);
            }
            multiPartEmail.send();
        }
        catch (MangooTemplateEngineException | EmailException throwable) {
            throw new MangooMailerException((Exception)throwable);
        }
    }

    private void sendHtmlEmail() throws MangooMailerException {
        try {
            HtmlEmail htmlEmail = new HtmlEmail();
            htmlEmail.setHostName(host);
            htmlEmail.setSmtpPort(port);
            htmlEmail.setAuthenticator((Authenticator)defaultAuthenticator);
            htmlEmail.setSSLOnConnect(ssl);
            htmlEmail.setFrom(this.from);
            htmlEmail.setSubject(this.subject);
            htmlEmail.setHtmlMsg(this.render());
            for (String object : this.recipients) {
                htmlEmail.addTo(object);
            }
            for (String string : this.ccRecipients) {
                htmlEmail.addCc(string);
            }
            for (String string : this.bccRecipients) {
                htmlEmail.addBcc(string);
            }
            for (File file : this.files) {
                htmlEmail.attach(file);
            }
            htmlEmail.send();
        }
        catch (MangooTemplateEngineException | EmailException throwable) {
            throw new MangooMailerException((Exception)throwable);
        }
    }

    private String render() throws MangooTemplateEngineException {
        return StringUtils.isNotBlank((CharSequence)this.body) ? this.body : Application.getInstance(TemplateEngine.class).render("", this.template, this.content);
    }
}

