/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.enums;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Template {
    DEFAULT;

    private transient Logger LOG = LogManager.getLogger(Template.class);
    private static final String TEMPLATES_FOLDER = "templates/";
    private String notFoundContent;
    private String badRequestContent;
    private String unauthorizedContent;
    private String forbiddenContent;
    private String serverErrorContent;
    private final String notFoundTemplatePath = "defaults/404.html";
    private final String badRequestTemplatePath = "defaults/400.html";
    private final String unauthorizedTemplatePath = "defaults/401.html";
    private final String forbiddenTemplatePath = "defaults/403.html";
    private final String serverErrorTemplatePath = "defaults/500.html";
    private final String routesTemplatePath = "admin/routes.ftl";
    private final String cacheTemplatePath = "admin/cache.ftl";
    private final String configurationTemplatePath = "admin/configuration.ftl";
    private final String metricsTemplatePath = "admin/metrics.ftl";
    private final String schedulerTemplatePath = "admin/scheduler.ftl";
    private final String adminTemplatePath = "admin/index.ftl";

    private Template() {
        try {
            this.notFoundContent = Resources.toString((URL)Resources.getResource((String)(TEMPLATES_FOLDER + this.notFoundTemplatePath)), (Charset)Charsets.UTF_8);
            this.badRequestContent = Resources.toString((URL)Resources.getResource((String)(TEMPLATES_FOLDER + this.badRequestTemplatePath)), (Charset)Charsets.UTF_8);
            this.unauthorizedContent = Resources.toString((URL)Resources.getResource((String)(TEMPLATES_FOLDER + this.unauthorizedTemplatePath)), (Charset)Charsets.UTF_8);
            this.forbiddenContent = Resources.toString((URL)Resources.getResource((String)(TEMPLATES_FOLDER + this.forbiddenTemplatePath)), (Charset)Charsets.UTF_8);
            this.serverErrorContent = Resources.toString((URL)Resources.getResource((String)(TEMPLATES_FOLDER + this.serverErrorTemplatePath)), (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            this.LOG.error("Failed to load default templates", (Throwable)iOException);
        }
    }

    public String forbidden() {
        return this.forbiddenContent;
    }

    public String notFound() {
        return this.notFoundContent;
    }

    public String badRequest() {
        return this.badRequestContent;
    }

    public String unauthorized() {
        return this.unauthorizedContent;
    }

    public String serverError() {
        return this.serverErrorContent;
    }

    public String forbiddenPath() {
        return this.forbiddenTemplatePath;
    }

    public String notFoundPath() {
        return this.notFoundTemplatePath;
    }

    public String badRequestPath() {
        return this.badRequestTemplatePath;
    }

    public String unauthorizedPath() {
        return this.unauthorizedTemplatePath;
    }

    public String serverErrorPath() {
        return this.serverErrorTemplatePath;
    }

    public String routesPath() {
        return this.routesTemplatePath;
    }

    public String cachePath() {
        return this.cacheTemplatePath;
    }

    public String configurationPath() {
        return this.configurationTemplatePath;
    }

    public String metricsPath() {
        return this.metricsTemplatePath;
    }

    public String schedulerPath() {
        return this.schedulerTemplatePath;
    }

    public String adminPath() {
        return this.adminTemplatePath;
    }
}

