/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.filters.oauth;

import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.mangoo.enums.Default;
import io.mangoo.enums.oauth.OAuthProvider;
import io.mangoo.enums.oauth.OAuthResource;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.models.OAuthUser;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.utils.RequestUtils;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class OAuthCallbackFilter
implements MangooFilter {
    private static final String PROFILE_IMAGE_URL_HTTPS = "$.profile_image_url_https";
    private static final String SCREEN_NAME = "$.screen_name";
    private static final String PICTURE = "$.picture";
    private static final String PICTURE_DATA_URL = "$.picture.data.url";
    private static final String NAME = "$.name";
    private static final String ID = "$.id";
    private static final String OAUTH_VERIFIER = "oauth_verifier";
    private static final String OAUTH_TOKEN = "oauth_token";
    private static final String CODE = "code";

    @Override
    public Response execute(Request request, Response response) {
        Optional<OAuthProvider> optional = RequestUtils.getOAuthProvider(request.getParameter(Default.OAUTH_REQUEST_PARAMETER.toString()));
        if (optional.isPresent()) {
            switch (optional.get()) {
                case TWITTER: {
                    this.twitterOAuth(request);
                    break;
                }
                case GOOGLE: {
                    this.googleOAuth(request);
                    break;
                }
                case FACEBOOK: {
                    this.facebookOAuth(request);
                    break;
                }
            }
        }
        return response;
    }

    private void facebookOAuth(Request request) {
        String string = request.getParameter(CODE);
        Optional<OAuthService> optional = RequestUtils.createOAuthService(OAuthProvider.FACEBOOK);
        if (StringUtils.isNotBlank((CharSequence)string) && optional.isPresent()) {
            OAuth20Service oAuth20Service = (OAuth20Service)optional.get();
            OAuth2AccessToken oAuth2AccessToken = oAuth20Service.getAccessToken(string);
            com.github.scribejava.core.model.Response response = this.getResourceResponse(oAuth20Service, oAuth2AccessToken, OAuthResource.FACEBOOK.toString());
            String string2 = response.getBody();
            if (response.isSuccessful() && StringUtils.isNotBlank((CharSequence)string2)) {
                DocumentContext documentContext = JsonPath.parse((String)string2);
                request.getAuthentication().setOAuthUser(new OAuthUser((String)documentContext.read(ID, new Predicate[0]), string2, (String)documentContext.read(NAME, new Predicate[0]), (String)documentContext.read(PICTURE_DATA_URL, new Predicate[0])));
            }
        }
    }

    private void googleOAuth(Request request) {
        String string = request.getParameter(CODE);
        Optional<OAuthService> optional = RequestUtils.createOAuthService(OAuthProvider.GOOGLE);
        if (StringUtils.isNotBlank((CharSequence)string) && optional.isPresent()) {
            OAuth20Service oAuth20Service = (OAuth20Service)optional.get();
            OAuth2AccessToken oAuth2AccessToken = oAuth20Service.getAccessToken(string);
            com.github.scribejava.core.model.Response response = this.getResourceResponse(oAuth20Service, oAuth2AccessToken, OAuthResource.GOOGLE.toString());
            String string2 = response.getBody();
            if (response.isSuccessful() && StringUtils.isNotBlank((CharSequence)string2)) {
                DocumentContext documentContext = JsonPath.parse((String)response.getBody());
                request.getAuthentication().setOAuthUser(new OAuthUser((String)documentContext.read(ID, new Predicate[0]), string2, (String)documentContext.read(NAME, new Predicate[0]), (String)documentContext.read(PICTURE, new Predicate[0])));
            }
        }
    }

    private void twitterOAuth(Request request) {
        String string = request.getParameter(OAUTH_TOKEN);
        String string2 = request.getParameter(OAUTH_VERIFIER);
        Optional<OAuthService> optional = RequestUtils.createOAuthService(OAuthProvider.TWITTER);
        if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2) && optional.isPresent()) {
            OAuth1RequestToken oAuth1RequestToken = new OAuth1RequestToken(string, string2);
            OAuth10aService oAuth10aService = (OAuth10aService)optional.get();
            OAuth1AccessToken oAuth1AccessToken = oAuth10aService.getAccessToken(oAuth1RequestToken, string2);
            com.github.scribejava.core.model.Response response = this.getResourceResponse(oAuth10aService, oAuth1AccessToken, OAuthResource.TWITTER.toString());
            String string3 = response.getBody();
            if (response.isSuccessful() && StringUtils.isNotBlank((CharSequence)string3)) {
                DocumentContext documentContext = JsonPath.parse((String)response.getBody());
                request.getAuthentication().setOAuthUser(new OAuthUser((String)documentContext.read(ID, new Predicate[0]), response.getBody(), (String)documentContext.read(SCREEN_NAME, new Predicate[0]), (String)documentContext.read(PROFILE_IMAGE_URL_HTTPS, new Predicate[0])));
            }
        }
    }

    private com.github.scribejava.core.model.Response getResourceResponse(OAuth20Service oAuth20Service, OAuth2AccessToken oAuth2AccessToken, String string) {
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, string, (OAuthService)oAuth20Service);
        oAuth20Service.signRequest(oAuth2AccessToken, (AbstractRequest)oAuthRequest);
        return oAuthRequest.send();
    }

    private com.github.scribejava.core.model.Response getResourceResponse(OAuth10aService oAuth10aService, OAuth1AccessToken oAuth1AccessToken, String string) {
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, string, (OAuthService)oAuth10aService);
        oAuth10aService.signRequest(oAuth1AccessToken, (AbstractRequest)oAuthRequest);
        return oAuthRequest.send();
    }
}

