/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.filters.oauth;

import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import io.mangoo.enums.Default;
import io.mangoo.enums.oauth.OAuthProvider;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.utils.RequestUtils;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class OAuthLoginFilter
implements MangooFilter {
    @Override
    public Response execute(Request request, Response response) {
        Optional<OAuthService> optional;
        Optional<OAuthProvider> optional2 = RequestUtils.getOAuthProvider(request.getParameter(Default.OAUTH_REQUEST_PARAMETER.toString()));
        if (optional2.isPresent() && (optional = RequestUtils.createOAuthService(optional2.get())).isPresent()) {
            String string = null;
            switch (optional2.get()) {
                case TWITTER: {
                    OAuth10aService oAuth10aService = (OAuth10aService)optional.get();
                    OAuth1RequestToken oAuth1RequestToken = oAuth10aService.getRequestToken();
                    string = oAuth10aService.getAuthorizationUrl(oAuth1RequestToken);
                    break;
                }
                case GOOGLE: {
                    OAuth20Service oAuth20Service = (OAuth20Service)optional.get();
                    string = oAuth20Service.getAuthorizationUrl(null);
                    break;
                }
                case FACEBOOK: {
                    OAuth20Service oAuth20Service = (OAuth20Service)optional.get();
                    string = oAuth20Service.getAuthorizationUrl(null);
                    break;
                }
            }
            if (StringUtils.isNotBlank(string)) {
                return Response.withRedirect(URI.create(string).toString()).end();
            }
        }
        return response;
    }
}

