/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.i18n;

import com.google.inject.Singleton;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Validation;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class Messages {
    private final Map<String, String> defaults = new ConcurrentHashMap<String, String>(16, 0.9f, 1);
    private ResourceBundle bundle = ResourceBundle.getBundle(Default.BUNDLE_NAME.toString(), Locale.getDefault());
    private Locale locale;

    public Messages() {
        this.defaults.put(Key.VALIDATION_REQUIRED.toString(), Validation.REQUIRED.toString());
        this.defaults.put(Key.VALIDATION_MIN.toString(), Validation.MIN.toString());
        this.defaults.put(Key.VALIDATION_MAX.toString(), Validation.MAX.toString());
        this.defaults.put(Key.VALIDATION_EXACT_MATCH.toString(), Validation.EXACT_MATCH.toString());
        this.defaults.put(Key.VALIDATION_MATCH.toString(), Validation.MATCH.toString());
        this.defaults.put(Key.VALIDATION_EMAIL.toString(), Validation.EMAIL.toString());
        this.defaults.put(Key.VALIDATION_IPV4.toString(), Validation.IPV4.toString());
        this.defaults.put(Key.VALIDATION_IPV6.toString(), Validation.IPV6.toString());
        this.defaults.put(Key.VALIDATION_RANGE.toString(), Validation.RANGE.toString());
        this.defaults.put(Key.VALIDATION_URL.toString(), Validation.URL.toString());
        this.defaults.put(Key.VALIDATION_REGEX.toString(), Validation.REGEX.toString());
        this.defaults.put(Key.VALIDATION_NUMERIC.toString(), Validation.NUMERIC.toString());
    }

    public void reload() {
        if (!Locale.getDefault().equals(this.locale)) {
            this.locale = Locale.getDefault();
            this.bundle = ResourceBundle.getBundle(Default.BUNDLE_NAME.toString(), Locale.getDefault());
        }
    }

    public String get(String string) {
        return this.bundle.getString(string);
    }

    public String get(String string, Object ... objectArray) {
        if (this.bundle.containsKey(string)) {
            return MessageFormat.format(this.bundle.getString(string), objectArray);
        }
        if (this.defaults.containsKey(string)) {
            return MessageFormat.format(this.defaults.get(string), objectArray);
        }
        return "";
    }

    public String get(Key key, Object ... objectArray) {
        return this.get(key.toString(), objectArray);
    }
}

