/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.managers;

import com.google.inject.Singleton;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Singleton
public class ExecutionManager {
    private static final Config CONFIG = Application.getConfig();
    private final ExecutorService executorService = Executors.newFixedThreadPool(CONFIG.getExecutionPool());

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executorService.submit(callable);
    }

    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.executorService.submit(runnable, t);
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }
}

