/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.models;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;

@Singleton
public class Metrics {
    private final AtomicIntegerFieldUpdater<Metrics> maxRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(Metrics.class, "maxRequestTime");
    private final AtomicIntegerFieldUpdater<Metrics> minRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(Metrics.class, "minRequestTime");
    private final AtomicLongFieldUpdater<Metrics> totalRequestTimeUpdater = AtomicLongFieldUpdater.newUpdater(Metrics.class, "totalRequestTime");
    private final AtomicLongFieldUpdater<Metrics> totalRequestsUpdater = AtomicLongFieldUpdater.newUpdater(Metrics.class, "totalRequests");
    private final Map<Integer, LongAdder> metricsCount = new ConcurrentHashMap<Integer, LongAdder>(16, 0.9f, 1);
    private volatile int maxRequestTime;
    private volatile int avgRequestTime;
    private volatile long totalRequestTime;
    private volatile long totalRequests;
    private volatile int minRequestTime = -1;

    public Metrics() {
    }

    public Metrics(Metrics metrics) {
        this.totalRequestTime = metrics.totalRequestTime;
        this.maxRequestTime = metrics.maxRequestTime;
        this.minRequestTime = metrics.minRequestTime;
        this.totalRequests = metrics.totalRequests;
    }

    public void inc(int n2) {
        this.metricsCount.computeIfAbsent(n2, n -> new LongAdder()).increment();
    }

    public void update(int n) {
        int n2;
        int n3;
        this.totalRequestTimeUpdater.addAndGet(this, n);
        while (n >= (n3 = this.maxRequestTime) && !this.maxRequestTimeUpdater.compareAndSet(this, n3, n)) {
        }
        while (!(n > (n2 = this.minRequestTime) && n2 != -1 || this.minRequestTimeUpdater.compareAndSet(this, n2, n))) {
        }
        this.totalRequestsUpdater.incrementAndGet(this);
        this.avgRequestTime = (int)(this.totalRequestTime / this.totalRequests);
    }

    public Map<Integer, LongAdder> getMetrics() {
        return this.metricsCount;
    }

    public int getMaxRequestTime() {
        return this.maxRequestTime;
    }

    public int getMinRequestTime() {
        return this.minRequestTime;
    }

    public int getAvgRequestTime() {
        return this.avgRequestTime;
    }
}

