/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.providers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.mangoo.cache.Cache;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class CacheProvider
implements Provider<Cache> {
    private static final Logger LOG = LogManager.getLogger(CacheProvider.class);
    private static final Config CONFIG = Application.getConfig();
    private Cache cache;

    @Inject
    public CacheProvider(Injector injector) {
        Class<Cache> clazz = null;
        try {
            clazz = Class.forName(CONFIG.getCacheClass()).asSubclass(Cache.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.error("Can not find cache class: " + CONFIG.getCacheClass(), (Throwable)classNotFoundException);
        }
        if (clazz != null) {
            this.cache = (Cache)injector.getInstance(clazz);
            LOG.info("Using {} as implementation for Cache", clazz);
        }
    }

    public Cache get() {
        return this.cache;
    }
}

