/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.providers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.templating.TemplateEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class TemplateEngineProvider
implements Provider<TemplateEngine> {
    private static final Logger LOG = LogManager.getLogger(TemplateEngineProvider.class);
    private static final Config CONFIG = Application.getConfig();
    private TemplateEngine templateEngine;

    @Inject
    public TemplateEngineProvider(Injector injector) {
        Class<TemplateEngine> clazz = null;
        try {
            clazz = Class.forName(CONFIG.getTemplateEngineClass()).asSubclass(TemplateEngine.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.error("Can not find Template Engine class: " + CONFIG.getTemplateEngineClass(), (Throwable)classNotFoundException);
        }
        if (clazz != null) {
            this.templateEngine = (TemplateEngine)injector.getInstance(clazz);
            LOG.info("Using {} as implementation for Template Engine", clazz);
        }
    }

    public TemplateEngine get() {
        return this.templateEngine;
    }
}

