/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import com.google.common.base.Charsets;
import io.mangoo.enums.ContentType;
import io.mangoo.utils.JsonUtils;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Response {
    private static final Logger LOG = LogManager.getLogger(Response.class);
    private final Map<HttpString, String> headers = new HashMap<HttpString, String>();
    private final Map<String, Object> content = new HashMap<String, Object>();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String redirectTo;
    private String contentType = ContentType.TEXT_PLAIN.toString();
    private String charset = Charsets.UTF_8.name();
    private String body = "";
    private String template;
    private String binaryFileName;
    private byte[] binaryContent;
    private boolean endResponse;
    private boolean etag;
    private boolean binary;
    private boolean rendered;
    private boolean redirect;
    private int statusCode = 200;

    public Response() {
    }

    private Response(int n) {
        this.statusCode = n;
    }

    private Response(String string) {
        Objects.requireNonNull(string, "redirectTo can not be null");
        this.redirect = true;
        this.rendered = true;
        this.redirectTo = string;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getBody() {
        return this.body;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public byte[] getBinaryContent() {
        return (byte[])this.binaryContent.clone();
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean isETag() {
        return this.etag;
    }

    public String getBinaryFileName() {
        return this.binaryFileName;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public boolean isEndResponse() {
        return this.endResponse;
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public Map<HttpString, String> getHeaders() {
        return this.headers;
    }

    public static Response withOk() {
        return new Response(200);
    }

    public static Response withCreated() {
        return new Response(201);
    }

    public static Response withNotFound() {
        return new Response(404);
    }

    public static Response withForbidden() {
        return new Response(403);
    }

    public static Response withUnauthorized() {
        return new Response(401);
    }

    public static Response withBadRequest() {
        return new Response(400);
    }

    public static Response withInternalServerError() {
        return new Response(500);
    }

    public static Response withStatusCode(int n) {
        return new Response(n);
    }

    public static Response withRedirect(String string) {
        Objects.requireNonNull(string, "redirectTo can not be null");
        return new Response(string);
    }

    public Response andTemplate(String string) {
        Objects.requireNonNull(string, "template can not be null");
        this.template = string;
        return this;
    }

    public Response andContentType(String string) {
        Objects.requireNonNull(string, "contentType can not be null");
        this.contentType = string;
        return this;
    }

    public Response andCharset(String string) {
        Objects.requireNonNull(string, "charset can not be null");
        this.charset = string;
        return this;
    }

    public Response andContent(String string, Object object) {
        Objects.requireNonNull(string, "name can not be null");
        this.content.put(string, object);
        return this;
    }

    public Response andBody(String string) {
        this.body = string;
        this.rendered = true;
        this.contentType = ContentType.TEXT_HTML.toString();
        return this;
    }

    public Response andCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie can not be null");
        this.cookies.add(cookie);
        return this;
    }

    public Response andJsonBody(Object object) {
        Objects.requireNonNull(object, "jsonObject can not be null");
        this.contentType = ContentType.APPLICATION_JSON.toString();
        this.body = JsonUtils.toJson(object);
        this.rendered = true;
        return this;
    }

    public Response andBinaryFile(File file) {
        Objects.requireNonNull(file, "file can not be null");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.binaryFileName = file.getName();
            this.binaryContent = IOUtils.toByteArray((InputStream)fileInputStream);
            this.binary = true;
            this.rendered = true;
        }
        catch (IOException iOException) {
            LOG.error("Failed to handle binary file", (Throwable)iOException);
        }
        return this;
    }

    public Response andBinaryContent(byte[] byArray) {
        Objects.requireNonNull(byArray, "content can not be null");
        this.binaryContent = (byte[])byArray.clone();
        this.binary = true;
        this.rendered = true;
        return this;
    }

    public Response andTextBody(String string) {
        this.contentType = ContentType.TEXT_PLAIN.toString();
        this.body = string;
        this.rendered = true;
        return this;
    }

    public Response andEmptyBody() {
        this.contentType = ContentType.TEXT_PLAIN.toString();
        this.rendered = true;
        return this;
    }

    public Response andHeader(HttpString httpString, String string) {
        Objects.requireNonNull(httpString, "key can not be null");
        this.headers.put(httpString, string);
        return this;
    }

    public Response andContent(Map<String, Object> map) {
        Objects.requireNonNull(map, "content can not be null");
        this.content.putAll(map);
        return this;
    }

    public Response andHeaders(Map<HttpString, String> map) {
        Objects.requireNonNull(map, "headers can not be null");
        this.headers.putAll(map);
        return this;
    }

    public Response andEtag() {
        this.etag = true;
        return this;
    }

    public Response end() {
        this.endResponse = true;
        return this;
    }
}

