/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import io.mangoo.enums.RouteType;
import io.undertow.util.HttpString;
import java.util.Objects;

public class Route {
    private Class<?> controllerClass;
    private String controllerMethod;
    private HttpString requestMethod;
    private String url;
    private final RouteType routeType;
    private boolean authentication;
    private boolean blocking;
    private boolean internalTemplateEngine;

    public Route(RouteType routeType) {
        this.routeType = Objects.requireNonNull(routeType, "routeType can not be null");
    }

    public Route toUrl(String string) {
        this.url = Objects.requireNonNull(string, "url can not be null");
        if (RouteType.RESOURCE_PATH.equals((Object)this.routeType)) {
            if ('/' != this.url.charAt(0)) {
                this.url = "/" + this.url;
            }
            if (!this.url.endsWith("/")) {
                this.url = this.url + "/";
            }
        } else if ('/' != this.url.charAt(0)) {
            this.url = "/" + this.url;
        }
        return this;
    }

    public Route withClass(Class<?> clazz) {
        this.controllerClass = clazz;
        return this;
    }

    public Route withMethod(String string) {
        this.controllerMethod = string;
        return this;
    }

    public Route withRequest(HttpString httpString) {
        this.requestMethod = httpString;
        return this;
    }

    public Route withAuthentication(boolean bl) {
        this.authentication = bl;
        return this;
    }

    public Route allowBlocking(boolean bl) {
        this.blocking = bl;
        return this;
    }

    public Route useInternalTemplateEngine() {
        this.internalTemplateEngine = true;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public String getControllerMethod() {
        return this.controllerMethod;
    }

    public HttpString getRequestMethod() {
        return this.requestMethod;
    }

    public boolean isAuthenticationRequired() {
        return this.authentication;
    }

    public boolean isInternalTemplateEngine() {
        return this.internalTemplateEngine;
    }

    public boolean isBlockingAllowed() {
        return this.blocking;
    }
}

