/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import io.mangoo.enums.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Flash {
    private static final Logger LOG = LogManager.getLogger(Flash.class);
    private static final List<String> BLACKLIST = Arrays.asList("|", ":", "&", " ");
    private Map<String, String> values = new HashMap<String, String>();
    private boolean discard;

    public Flash() {
    }

    public Flash(Map<String, String> map) {
        this.values = map;
    }

    public void setError(String string) {
        if (this.validCharacters(string)) {
            this.values.put(Key.ERROR.toString(), string);
        }
    }

    public void setWarning(String string) {
        if (this.validCharacters(string)) {
            this.values.put(Key.WARNING.toString(), string);
        }
    }

    public void setSuccess(String string) {
        if (this.validCharacters(string)) {
            this.values.put(Key.SUCCESS.toString(), string);
        }
    }

    public void put(String string, String string2) {
        if (this.validCharacters(string) && this.validCharacters(string2)) {
            this.values.put(string, string2);
        }
    }

    public String get(String string) {
        return this.values.get(string);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean bl) {
        this.discard = bl;
    }

    public boolean hasContent() {
        return !this.values.isEmpty();
    }

    private boolean validCharacters(String string) {
        if (BLACKLIST.contains(string)) {
            LOG.error("Flash key or value can not contain the following characters: spaces, |, & or :");
            return false;
        }
        return true;
    }
}

