/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import com.google.inject.Inject;
import io.mangoo.interfaces.MangooValidator;
import io.mangoo.routing.bindings.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Form
implements MangooValidator {
    private static final String KEY_ERROR = "Key can not be null";
    private final List<File> files = new ArrayList<File>();
    private final Map<String, String> values = new HashMap<String, String>();
    private final Validator validator;
    private boolean submitted;

    @Inject
    public Form(Validator validator) {
        this.validator = Objects.requireNonNull(validator, "Validator can not be null");
    }

    @Override
    public Validator validation() {
        return this.validator;
    }

    @Override
    public String getError(String string) {
        return this.validator.hasError(string) ? this.validator.getError(string) : "";
    }

    public boolean hasError(String string) {
        return this.validator.hasError(string);
    }

    public boolean hasErrors() {
        return this.validator.hasErrors();
    }

    public String get(String string) {
        Objects.requireNonNull(string, KEY_ERROR);
        return this.values.get(string);
    }

    public Optional<String> getString(String string) {
        Objects.requireNonNull(string, KEY_ERROR);
        String string2 = this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Optional.of(string2);
        }
        return Optional.empty();
    }

    public Optional<Boolean> getBoolean(String string) {
        Objects.requireNonNull(string, KEY_ERROR);
        String string2 = this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            if ("1".equals(string2)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("true".equals(string2)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("false".equals(string2)) {
                return Optional.of(Boolean.FALSE);
            }
            if ("0".equals(string2)) {
                return Optional.of(Boolean.FALSE);
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getInteger(String string) {
        Objects.requireNonNull(string, KEY_ERROR);
        String string2 = this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2) && NumberUtils.isNumber((String)string2)) {
            return Optional.of(Integer.valueOf(string2));
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(String string) {
        Objects.requireNonNull(string, KEY_ERROR);
        String string2 = this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2) && NumberUtils.isNumber((String)string2)) {
            return Optional.of(Double.valueOf(string2));
        }
        return Optional.empty();
    }

    public Optional<Float> getFloat(String string) {
        Objects.requireNonNull(string, KEY_ERROR);
        String string2 = this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2) && NumberUtils.isNumber((String)string2)) {
            return Optional.of(Float.valueOf(string2));
        }
        return Optional.empty();
    }

    public List<File> getFiles() {
        return this.files;
    }

    public Optional<File> getFile() {
        if (!this.files.isEmpty()) {
            return Optional.of(this.files.get(0));
        }
        return Optional.empty();
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public void setSubmitted(boolean bl) {
        this.submitted = bl;
    }

    public void addValue(String string, String string2) {
        this.values.put(string, string2);
        this.validator.add(string, string2);
    }
}

