/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import com.google.inject.Inject;
import io.mangoo.enums.Key;
import io.mangoo.i18n.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class Validator {
    private final Map<String, String> errors = new HashMap<String, String>();
    private Map<String, String> values = new HashMap<String, String>();
    private final Messages messages;

    @Inject
    public Validator(Messages messages) {
        this.messages = Objects.requireNonNull(messages, "Messages can not be null");
    }

    public boolean hasError(String string) {
        return this.errors.containsKey(string);
    }

    public String getError(String string) {
        return this.hasError(string) ? this.errors.get(string) : "";
    }

    public void required(String string) {
        this.required(string, this.messages.get(Key.VALIDATION_REQUIRED, string));
    }

    public void required(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isBlank((CharSequence)StringUtils.trimToNull((String)string3))) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_REQUIRED, string)));
        }
    }

    public void min(String string, double d) {
        this.min(string, d, this.messages.get(Key.VALIDATION_MIN, string, d));
    }

    public void min(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            if (Double.valueOf(string3) < d) {
                this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_MIN, string, d)));
            }
        } else if ((double)string3.length() < d) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_MIN, string, d)));
        }
    }

    public void max(String string, double d) {
        this.max(string, d, this.messages.get(Key.VALIDATION_MAX, string, d));
    }

    public void numeric(String string) {
        this.numeric(string, this.messages.get(Key.VALIDATION_NUMERIC, string));
    }

    public void numeric(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!StringUtils.isNumeric((CharSequence)string3)) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_NUMERIC, string)));
        }
    }

    public void max(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            if (Double.valueOf(string3) > d) {
                this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_MAX, string, d)));
            }
        } else if ((double)string3.length() > d) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_MAX, string, d)));
        }
    }

    public void exactMatch(String string, String string2) {
        this.exactMatch(string, string2, this.messages.get(Key.VALIDATION_EXACT_MATCH, string, string2));
    }

    public void exactMatch(String string, String string2, String string3) {
        String string4 = Optional.ofNullable(this.get(string)).orElse("");
        String string5 = Optional.ofNullable(this.get(string2)).orElse("");
        if (StringUtils.isBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5) || !string4.equals(string5)) {
            this.errors.put(string, Optional.ofNullable(string3).orElse(this.messages.get(Key.VALIDATION_EXACT_MATCH, string, string2)));
        }
    }

    public void match(String string, String string2) {
        this.match(string, string2, this.messages.get(Key.VALIDATION_MATCH, string, string2));
    }

    public void match(String string, String string2, String string3) {
        String string4 = Optional.ofNullable(this.get(string)).orElse("");
        String string5 = Optional.ofNullable(this.get(string2)).orElse("");
        if (StringUtils.isBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5) || !string4.equalsIgnoreCase(string5)) {
            this.errors.put(string, Optional.ofNullable(string3).orElse(this.messages.get(Key.VALIDATION_MATCH, string, string2)));
        }
    }

    public void email(String string) {
        this.email(string, this.messages.get(Key.VALIDATION_EMAIL, string));
    }

    public void email(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!EmailValidator.getInstance().isValid(string3)) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_EMAIL, string)));
        }
    }

    public void ipv4(String string) {
        this.ipv4(string, this.messages.get(Key.VALIDATION_IPV4, string));
    }

    public void ipv4(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!InetAddressValidator.getInstance().isValidInet4Address(string3)) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_IPV4, string)));
        }
    }

    public void ipv6(String string) {
        this.ipv6(string, this.messages.get(Key.VALIDATION_IPV6, string));
    }

    public void ipv6(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!InetAddressValidator.getInstance().isValidInet6Address(string3)) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_IPV6, string)));
        }
    }

    public void range(String string, int n, int n2) {
        this.range(string, n, n2, this.messages.get(Key.VALIDATION_RANGE, string, n, n2));
    }

    public void range(String string, int n, int n2, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            double d = Double.parseDouble(string3);
            if (d < (double)n || d > (double)n2) {
                this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_RANGE, string, n, n2)));
            }
        } else if (string3.length() < n || string3.length() > n2) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_RANGE, string, n, n2)));
        }
    }

    public void regex(String string, Pattern pattern) {
        this.regex(string, pattern, this.messages.get(Key.VALIDATION_REGEX, string));
    }

    public void regex(String string, Pattern pattern, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!pattern.matcher(string3).matches()) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_REGEX, string)));
        }
    }

    public void url(String string) {
        this.url(string, this.messages.get(Key.VALIDATION_URL, string));
    }

    public void url(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!UrlValidator.getInstance().isValid(string3)) {
            this.errors.put(string, Optional.ofNullable(string2).orElse(this.messages.get(Key.VALIDATION_URL, string)));
        }
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public String get(String string) {
        return this.values.get(string);
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setValues(Map<String, String> map) {
        this.values = map;
    }

    public void add(String string, String string2) {
        this.values.put(string, string2);
    }
}

