/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.handlers.InboundCookiesHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import io.undertow.util.LocaleUtils;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class LocaleHandler
implements HttpHandler {
    private static final Config CONFIG = Application.getConfig();

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Locale locale = Locale.forLanguageTag(CONFIG.getApplicationLanguage());
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.ATTACHMENT_KEY);
        HeaderValues headerValues = httpServerExchange.getRequestHeaders().get("Accept-Language");
        Cookie cookie = (Cookie)httpServerExchange.getRequestCookies().get(CONFIG.getI18nCookieName());
        if (cookie == null) {
            String string;
            if (headerValues != null && StringUtils.isNotBlank((CharSequence)(string = headerValues.element()))) {
                locale = LocaleUtils.getLocaleFromString((String)string);
            }
        } else {
            locale = LocaleUtils.getLocaleFromString((String)cookie.getValue());
        }
        Locale.setDefault(locale);
        attachment.getMessages().reload();
        this.nextHandler(httpServerExchange);
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(InboundCookiesHandler.class).handleRequest(httpServerExchange);
    }
}

