/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.common.base.Joiner;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.handlers.ResponseHandler;
import io.mangoo.utils.CookieBuilder;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.time.LocalDateTime;
import org.apache.commons.codec.digest.DigestUtils;

public class OutboundCookiesHandler
implements HttpHandler {
    private static final Config CONFIG = Application.getConfig();
    private Attachment requestAttachment;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.requestAttachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.ATTACHMENT_KEY);
        this.setSessionCookie(httpServerExchange, this.requestAttachment.getSession());
        this.setFlashCookie(httpServerExchange, this.requestAttachment.getFlash());
        this.setAuthenticationCookie(httpServerExchange, this.requestAttachment.getAuthentication());
        this.nextHandler(httpServerExchange);
    }

    protected void setSessionCookie(HttpServerExchange httpServerExchange, Session session) {
        if (session != null && session.hasChanges()) {
            String string = Joiner.on((String)Default.SPLITTER.toString()).withKeyValueSeparator(Default.SEPERATOR.toString()).join(session.getValues());
            String string2 = CONFIG.getCookieVersion();
            String string3 = session.getAuthenticityToken();
            LocalDateTime localDateTime = session.getExpires();
            StringBuilder stringBuilder = new StringBuilder().append(DigestUtils.sha512Hex((String)(string + string3 + localDateTime + string2 + CONFIG.getApplicationSecret()))).append(Default.DELIMITER.toString()).append(string3).append(Default.DELIMITER.toString()).append(localDateTime).append(Default.DELIMITER.toString()).append(string2).append(Default.DATA_DELIMITER.toString()).append(string);
            String string4 = stringBuilder.toString();
            if (CONFIG.isSessionCookieEncrypt()) {
                string4 = this.requestAttachment.getCrypto().encrypt(string4);
            }
            Cookie cookie = CookieBuilder.create().name(CONFIG.getSessionCookieName()).value(string4).secure(CONFIG.isSessionCookieSecure()).httpOnly(true).expires(localDateTime).build();
            httpServerExchange.setResponseCookie(cookie);
        }
    }

    protected void setAuthenticationCookie(HttpServerExchange httpServerExchange, Authentication authentication) {
        if (authentication != null && authentication.hasAuthenticatedUser()) {
            Cookie cookie;
            String string = CONFIG.getAuthenticationCookieName();
            if (authentication.isLogout()) {
                cookie = (Cookie)httpServerExchange.getRequestCookies().get(string);
                cookie.setSecure(CONFIG.isAuthenticationCookieSecure());
                cookie.setHttpOnly(true);
                cookie.setPath("/");
                cookie.setMaxAge(Integer.valueOf(0));
                cookie.setDiscard(true);
            } else {
                String string2 = authentication.getAuthenticatedUser();
                LocalDateTime localDateTime = authentication.isRemember() ? LocalDateTime.now().plusSeconds(CONFIG.getAuthenticationRememberExpires()) : authentication.getExpires();
                String string3 = CONFIG.getAuthCookieVersion();
                StringBuilder stringBuilder = new StringBuilder().append(DigestUtils.sha512Hex((String)(string2 + localDateTime + string3 + CONFIG.getApplicationSecret()))).append(Default.DELIMITER.toString()).append(localDateTime).append(Default.DELIMITER.toString()).append(string3).append(Default.DATA_DELIMITER.toString()).append(string2);
                String string4 = stringBuilder.toString();
                if (CONFIG.isAuthenticationCookieEncrypt()) {
                    string4 = this.requestAttachment.getCrypto().encrypt(string4);
                }
                cookie = CookieBuilder.create().name(string).value(string4).secure(CONFIG.isAuthenticationCookieSecure()).httpOnly(true).expires(localDateTime).build();
            }
            httpServerExchange.setResponseCookie(cookie);
        }
    }

    protected void setFlashCookie(HttpServerExchange httpServerExchange, Flash flash) {
        if (flash != null && !flash.isDiscard() && flash.hasContent()) {
            String string = Joiner.on((String)"&").withKeyValueSeparator(":").join(flash.getValues());
            Cookie cookie = CookieBuilder.create().name(CONFIG.getFlashCookieName()).value(string).secure(CONFIG.isFlashCookieSecure()).httpOnly(true).build();
            httpServerExchange.setResponseCookie(cookie);
        } else {
            Cookie cookie = (Cookie)httpServerExchange.getRequestCookies().get(CONFIG.getFlashCookieName());
            if (cookie != null) {
                cookie.setHttpOnly(true).setSecure(CONFIG.isFlashCookieSecure()).setPath("/").setMaxAge(Integer.valueOf(0));
                httpServerExchange.setResponseCookie(cookie);
            }
        }
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(ResponseHandler.class).handleRequest(httpServerExchange);
    }
}

