/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import freemarker.template.TemplateException;
import io.mangoo.annotations.FilterWith;
import io.mangoo.core.Application;
import io.mangoo.enums.Binding;
import io.mangoo.enums.Default;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.interfaces.MangooRequestFilter;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.routing.handlers.OutboundCookiesHandler;
import io.mangoo.utils.JsonUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestHandler
implements HttpHandler {
    private Attachment requestAttachment;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.requestAttachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.ATTACHMENT_KEY);
        this.requestAttachment.setBody(this.getRequestBody(httpServerExchange));
        this.requestAttachment.setRequest(this.getRequest(httpServerExchange));
        Response response = this.getResponse(httpServerExchange);
        response.getCookies().forEach(arg_0 -> ((HttpServerExchange)httpServerExchange).setResponseCookie(arg_0));
        this.requestAttachment.setResponse(response);
        httpServerExchange.putAttachment(RequestUtils.ATTACHMENT_KEY, (Object)this.requestAttachment);
        this.nextHandler(httpServerExchange);
    }

    protected Request getRequest(HttpServerExchange httpServerExchange) {
        String string = Optional.ofNullable(this.requestAttachment.getRequestParameter().get(Default.AUTHENTICITY_TOKEN.toString())).orElse(this.requestAttachment.getForm().get(Default.AUTHENTICITY_TOKEN.toString()));
        return new Request(httpServerExchange, this.requestAttachment.getSession(), string, this.requestAttachment.getAuthentication(), this.requestAttachment.getRequestParameter(), this.requestAttachment.getBody());
    }

    protected Response getResponse(HttpServerExchange httpServerExchange) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException, TemplateException, MangooTemplateEngineException {
        Response response = Response.withOk();
        if (this.requestAttachment.hasRequestFilter()) {
            MangooRequestFilter mangooRequestFilter = Application.getInstance(MangooRequestFilter.class);
            response = mangooRequestFilter.execute(this.requestAttachment.getRequest(), response);
        }
        if (response.isEndResponse()) {
            return response;
        }
        response = this.executeFilter(this.requestAttachment.getControllerClass().getAnnotations(), response);
        if (response.isEndResponse()) {
            return response;
        }
        response = this.executeFilter(this.requestAttachment.getMethod().getAnnotations(), response);
        if (response.isEndResponse()) {
            return response;
        }
        return this.invokeController(httpServerExchange, response);
    }

    protected Response invokeController(HttpServerExchange httpServerExchange, Response response) throws IllegalAccessException, InvocationTargetException, IOException, TemplateException, MangooTemplateEngineException {
        Response response2;
        if (this.requestAttachment.getMethodParameters().isEmpty()) {
            response2 = (Response)this.requestAttachment.getMethod().invoke(this.requestAttachment.getControllerInstance(), new Object[0]);
        } else {
            Object[] objectArray = this.getConvertedParameters(httpServerExchange);
            response2 = (Response)this.requestAttachment.getMethod().invoke(this.requestAttachment.getControllerInstance(), objectArray);
        }
        response2.andContent(response.getContent());
        response2.andHeaders(response.getHeaders());
        if (!response2.isRendered()) {
            response2.andBody(this.requestAttachment.getTemplateEngine().render(this.requestAttachment.getFlash(), this.requestAttachment.getSession(), this.requestAttachment.getForm(), this.requestAttachment.getMessages(), this.getTemplatePath(response2), response2.getContent()));
        }
        return response2;
    }

    protected String getTemplatePath(Response response) {
        return StringUtils.isBlank((CharSequence)response.getTemplate()) ? this.requestAttachment.getControllerClassName() + "/" + this.requestAttachment.getTemplateEngine().getTemplateName(this.requestAttachment.getControllerMethodName()) : response.getTemplate();
    }

    protected Object[] getConvertedParameters(HttpServerExchange httpServerExchange) throws IOException {
        Object[] objectArray = new Object[this.requestAttachment.getMethodParametersCount()];
        int n = 0;
        for (Map.Entry<String, Class<?>> entry : this.requestAttachment.getMethodParameters().entrySet()) {
            String string = entry.getKey();
            Class<?> clazz = entry.getValue();
            Binding binding = Optional.ofNullable(Binding.fromString(clazz.getName())).orElse(Binding.UNDEFINED);
            switch (binding) {
                case FORM: {
                    objectArray[n] = this.requestAttachment.getForm();
                    break;
                }
                case AUTHENTICATION: {
                    objectArray[n] = this.requestAttachment.getAuthentication();
                    break;
                }
                case SESSION: {
                    objectArray[n] = this.requestAttachment.getSession();
                    break;
                }
                case FLASH: {
                    objectArray[n] = this.requestAttachment.getFlash();
                    break;
                }
                case REQUEST: {
                    objectArray[n] = this.requestAttachment.getRequest();
                    break;
                }
                case LOCALDATE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : LocalDate.parse(this.requestAttachment.getRequestParameter().get(string));
                    break;
                }
                case LOCALDATETIME: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : LocalDateTime.parse(this.requestAttachment.getRequestParameter().get(string));
                    break;
                }
                case STRING: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : this.requestAttachment.getRequestParameter().get(string);
                    break;
                }
                case INT_PRIMITIVE: 
                case INTEGER: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : Integer.valueOf(this.requestAttachment.getRequestParameter().get(string));
                    break;
                }
                case DOUBLE_PRIMITIVE: 
                case DOUBLE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : Double.valueOf(this.requestAttachment.getRequestParameter().get(string));
                    break;
                }
                case FLOAT_PRIMITIVE: 
                case FLOAT: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : Float.valueOf(this.requestAttachment.getRequestParameter().get(string));
                    break;
                }
                case LONG_PRIMITIVE: 
                case LONG: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.requestAttachment.getRequestParameter().get(string)) ? null : Long.valueOf(this.requestAttachment.getRequestParameter().get(string));
                    break;
                }
                case UNDEFINED: {
                    objectArray[n] = RequestUtils.isJsonRequest(httpServerExchange) ? JsonUtils.fromJson(this.requestAttachment.getBody(), clazz) : null;
                    break;
                }
                default: {
                    objectArray[n] = null;
                }
            }
            ++n;
        }
        return objectArray;
    }

    protected Response executeFilter(Annotation[] annotationArray, Response response) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Annotation annotation : annotationArray) {
            if (!annotation.annotationType().equals(FilterWith.class)) continue;
            FilterWith filterWith = (FilterWith)annotation;
            for (Class<? extends MangooFilter> clazz : filterWith.value()) {
                if (response.isEndResponse()) {
                    return response;
                }
                Method method = clazz.getMethod(Default.FILTER_METHOD.toString(), Request.class, Response.class);
                response = (Response)method.invoke((Object)Application.getInstance(clazz), this.requestAttachment.getRequest(), response);
            }
        }
        return response;
    }

    protected String getRequestBody(HttpServerExchange httpServerExchange) throws IOException {
        String string = "";
        if (RequestUtils.isPostOrPut(httpServerExchange)) {
            httpServerExchange.startBlocking();
            string = IOUtils.toString((InputStream)httpServerExchange.getInputStream(), (String)Default.ENCODING.toString());
        }
        return string;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(OutboundCookiesHandler.class).handleRequest(httpServerExchange);
    }
}

