/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Header;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.Response;
import io.mangoo.routing.handlers.BinaryHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class ResponseHandler
implements HttpHandler {
    private static final Config CONFIG = Application.getConfig();
    private Attachment requestAttachment;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.requestAttachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.ATTACHMENT_KEY);
        Response response = this.requestAttachment.getResponse();
        if (response.isRedirect()) {
            this.handleRedirectResponse(httpServerExchange, response);
        } else if (response.isBinary()) {
            this.handleBinaryResponse(httpServerExchange, response);
        } else {
            this.handleRenderedResponse(httpServerExchange, response);
        }
    }

    protected void handleBinaryResponse(HttpServerExchange httpServerExchange, Response response) throws IOException {
        httpServerExchange.dispatch(httpServerExchange.getDispatchExecutor(), (HttpHandler)new BinaryHandler(response));
    }

    protected void handleRedirectResponse(HttpServerExchange httpServerExchange, Response response) {
        httpServerExchange.setStatusCode(302);
        httpServerExchange.getResponseHeaders().put(Headers.LOCATION, response.getRedirectTo());
        httpServerExchange.getResponseHeaders().put(Headers.SERVER, Default.SERVER.toString());
        response.getHeaders().forEach((httpString, string) -> httpServerExchange.getResponseHeaders().add(httpString, string));
        httpServerExchange.endExchange();
    }

    protected String getResponseBody(HttpServerExchange httpServerExchange, Response response) {
        String string = response.getBody();
        if (response.isETag()) {
            String string2 = httpServerExchange.getRequestHeaders().getFirst("If-None-Match");
            String string3 = DigestUtils.md5Hex((String)string);
            if (StringUtils.isNotBlank((CharSequence)string2) && StringUtils.isNotBlank((CharSequence)string3) && string2.equals(string3)) {
                httpServerExchange.setStatusCode(304);
                string = "";
            } else {
                httpServerExchange.getResponseHeaders().put(Headers.ETAG, string3);
            }
        }
        return string;
    }

    protected void handleRenderedResponse(HttpServerExchange httpServerExchange, Response response) {
        httpServerExchange.setStatusCode(response.getStatusCode());
        httpServerExchange.getResponseHeaders().put(Header.X_XSS_PPROTECTION.toHttpString(), (long)Default.X_XSS_PPROTECTION.toInt());
        httpServerExchange.getResponseHeaders().put(Header.X_CONTENT_TYPE_OPTIONS.toHttpString(), Default.NOSNIFF.toString());
        httpServerExchange.getResponseHeaders().put(Header.X_FRAME_OPTIONS.toHttpString(), Default.SAMEORIGIN.toString());
        httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, response.getContentType() + "; charset=" + response.getCharset());
        httpServerExchange.getResponseHeaders().put(Headers.SERVER, Default.SERVER.toString());
        response.getHeaders().forEach((httpString, string) -> httpServerExchange.getResponseHeaders().add(httpString, string));
        if (CONFIG.isTimerEnabled()) {
            httpServerExchange.getResponseHeaders().put(Header.X_RESPONSE_TIME.toHttpString(), this.requestAttachment.getResponseTime() + " ms");
        }
        httpServerExchange.getResponseSender().send(this.getResponseBody(httpServerExchange, response));
    }
}

