/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.scheduler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.exceptions.MangooSchedulerException;
import io.mangoo.models.Job;
import io.mangoo.scheduler.SchedulerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;

@Singleton
public class Scheduler {
    private static final Logger LOG = LogManager.getLogger(Scheduler.class);
    private static final String SCHEDULER_IS_NOT_INITIALIZED = "Scheduler is not initialized";
    private org.quartz.Scheduler quartzScheduler;

    @Inject
    public Scheduler(Config config) {
        config.getAllConfigurations().entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith(Default.SCHEDULER_PREFIX.toString())) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        });
    }

    public void initialize() {
        try {
            this.quartzScheduler = new StdSchedulerFactory().getScheduler();
            this.quartzScheduler.setJobFactory((JobFactory)Application.getInstance(SchedulerFactory.class));
        }
        catch (SchedulerException schedulerException) {
            LOG.error("Failed to initialize scheduler", (Throwable)schedulerException);
        }
    }

    @Deprecated
    public org.quartz.Scheduler getScheduler() {
        return this.quartzScheduler;
    }

    public boolean isInitialize() {
        return this.quartzScheduler != null;
    }

    public org.quartz.Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void start() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        try {
            this.quartzScheduler.start();
            if (this.quartzScheduler.isStarted()) {
                LOG.info("Successfully started quartz scheduler");
            } else {
                LOG.error("Scheduler is not started");
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public void shutdown() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        try {
            this.quartzScheduler.shutdown();
            if (this.quartzScheduler.isShutdown()) {
                LOG.info("Successfully shutdown quartz scheduler");
            } else {
                LOG.error("Failed to shutdown scheduler");
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public void standby() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        try {
            this.quartzScheduler.standby();
            if (this.quartzScheduler.isInStandbyMode()) {
                LOG.info("Scheduler is now in standby");
            } else {
                LOG.error("Failed to put scheduler in standby");
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public void schedule(JobDetail jobDetail, Trigger trigger) throws MangooSchedulerException {
        Objects.requireNonNull(jobDetail, "JobDetail is required for schedule");
        Objects.requireNonNull(trigger, "trigger is required for schedule");
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        try {
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public List<Job> getAllJobs() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        ArrayList<Job> arrayList = new ArrayList<Job>();
        try {
            for (JobKey jobKey : this.getAllJobKeys()) {
                List list = this.quartzScheduler.getTriggersOfJob(jobKey);
                Trigger trigger = (Trigger)list.get(0);
                Trigger.TriggerState triggerState = this.quartzScheduler.getTriggerState(trigger.getKey());
                arrayList.add(new Job(!Trigger.TriggerState.PAUSED.equals((Object)triggerState), jobKey.getName(), trigger.getDescription(), trigger.getNextFireTime(), trigger.getPreviousFireTime()));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
        return arrayList;
    }

    public void executeJob(String string) throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        try {
            for (JobKey jobKey : this.getAllJobKeys()) {
                if (!jobKey.getName().equalsIgnoreCase(string)) continue;
                this.quartzScheduler.triggerJob(jobKey);
            }
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    public List<JobKey> getAllJobKeys() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        ArrayList<JobKey> arrayList = new ArrayList<JobKey>();
        try {
            for (String string : this.quartzScheduler.getJobGroupNames()) {
                arrayList.addAll(this.quartzScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)string)));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
        return arrayList;
    }

    public void changeState(String string) throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        try {
            for (JobKey jobKey : this.getAllJobKeys()) {
                if (!jobKey.getName().equalsIgnoreCase(string)) continue;
                Trigger.TriggerState triggerState = this.getTriggerState(jobKey);
                if (Trigger.TriggerState.NORMAL.equals((Object)triggerState)) {
                    this.quartzScheduler.pauseJob(jobKey);
                    continue;
                }
                this.quartzScheduler.resumeJob(jobKey);
            }
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    private Trigger.TriggerState getTriggerState(JobKey jobKey) throws SchedulerException {
        Objects.requireNonNull(this.quartzScheduler, SCHEDULER_IS_NOT_INITIALIZED);
        List list = this.quartzScheduler.getTriggersOfJob(jobKey);
        Trigger trigger = (Trigger)list.get(0);
        return this.quartzScheduler.getTriggerState(trigger.getKey());
    }
}

