/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating.freemarker;

import com.google.common.base.Charsets;
import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.i18n.Messages;
import io.mangoo.models.Source;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.templating.TemplateEngine;
import io.mangoo.templating.freemarker.TemplateEngineLoader;
import io.mangoo.templating.freemarker.directives.AuthenticityFormDirective;
import io.mangoo.templating.freemarker.directives.AuthenticityTokenDirective;
import io.mangoo.templating.freemarker.methods.I18nMethod;
import io.mangoo.utils.ThrowableUtils;
import io.undertow.server.HttpServerExchange;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TemplateEngineFreemarker
implements TemplateEngine {
    private final Configuration configuration = new Configuration(VERSION);
    private static final String TEMPLATE_SUFFIX = ".ftl";
    private static final int MAX_CHARS = 65536;
    private static final int ONE_SECOND_MS = 1000;
    private static final int STRONG_SIZE_LIMIT = 20;
    private static final Version VERSION = new Version(2, 3, 23);

    public TemplateEngineFreemarker() {
        this.configuration.setClassForTemplateLoading(this.getClass(), Default.TEMPLATES_FOLDER.toString());
        this.configuration.setDefaultEncoding(Charsets.UTF_8.name());
        this.configuration.setOutputEncoding(Charsets.UTF_8.name());
        this.configuration.setLocalizedLookup(false);
        this.configuration.setNumberFormat(Default.NUMBER_FORMAT.toString());
        this.configuration.setTemplateLoader((TemplateLoader)new TemplateEngineLoader(this.configuration.getTemplateLoader()));
        this.configuration.setAPIBuiltinEnabled(true);
        if (Application.inDevMode()) {
            this.configuration.setTemplateUpdateDelayMilliseconds(1000L);
        } else {
            this.configuration.setTemplateUpdateDelayMilliseconds(Integer.MAX_VALUE);
            this.configuration.setCacheStorage((CacheStorage)new MruCacheStorage(20, Integer.MAX_VALUE));
        }
    }

    @Override
    public String render(Flash flash, Session session, Form form, Messages messages, String string, Map<String, Object> map) throws MangooTemplateEngineException {
        Template template;
        try {
            template = this.configuration.getTemplate(string);
        }
        catch (IOException iOException) {
            throw new MangooTemplateEngineException("Template was not found on path:" + string, iOException);
        }
        map.put("form", form);
        map.put("flash", flash);
        map.put("session", session);
        map.put("i18n", new I18nMethod(messages));
        map.put("authenticityToken", new AuthenticityTokenDirective(session));
        map.put("authenticityForm", new AuthenticityFormDirective(session));
        return this.processTemplate(map, template);
    }

    @Override
    public String render(String string, String string2, Map<String, Object> map) throws MangooTemplateEngineException {
        Template template;
        try {
            template = this.configuration.getTemplate(string + "/" + this.getTemplateName(string2));
        }
        catch (IOException iOException) {
            throw new MangooTemplateEngineException("Failed to render template", iOException);
        }
        return this.processTemplate(map, template);
    }

    @Override
    public String renderException(HttpServerExchange httpServerExchange, Throwable throwable, boolean bl) throws MangooTemplateEngineException {
        String string;
        StackTraceElement stackTraceElement;
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("templateException", bl);
        if (bl) {
            hashMap.put("exceptions", throwable.getMessage().split("\n"));
        } else {
            List<Source> list;
            stackTraceElement = Arrays.asList(throwable.getStackTrace()).get(0);
            string = ThrowableUtils.getSourceCodePath(stackTraceElement);
            try {
                list = ThrowableUtils.getSources(stackTraceElement.getLineNumber(), string);
            }
            catch (IOException iOException) {
                throw new MangooTemplateEngineException("Failed to get source lines of exception", iOException);
            }
            hashMap.put("sources", list);
            hashMap.put("cause", ExceptionUtils.getMessage((Throwable)throwable));
            hashMap.put("url", httpServerExchange.getRequestURI());
            hashMap.put("method", httpServerExchange.getRequestMethod());
            hashMap.put("line", stackTraceElement.getLineNumber());
            hashMap.put("causeSource", throwable.toString());
            hashMap.put("stackTraces", throwable.getStackTrace());
            hashMap.put("sourceCodePath", StringUtils.substringAfter((String)new File(Application.getBaseDirectory()).toPath().resolve(string).toFile().getPath(), (String)"src/main/java") + " around line " + stackTraceElement.getLineNumber());
        }
        stackTraceElement = new Configuration(VERSION);
        stackTraceElement.setClassForTemplateLoading(this.getClass(), Default.DEFAULT_TEMPLATES_DIR.toString());
        try {
            string = stackTraceElement.getTemplate("exception.ftl");
            string.process(hashMap, (Writer)stringWriter);
        }
        catch (TemplateException | IOException throwable2) {
            throw new MangooTemplateEngineException("Failed to process template", (Exception)throwable2);
        }
        return ((Object)stringWriter).toString();
    }

    private String processTemplate(Map<String, Object> map, Template template) throws MangooTemplateEngineException {
        Objects.requireNonNull(map, "content can not be null");
        Objects.requireNonNull(template, "template can not be null");
        StringWriter stringWriter = new StringWriter(65536);
        try {
            template.process(map, (Writer)stringWriter);
        }
        catch (TemplateException | IOException throwable) {
            throw new MangooTemplateEngineException("Failed to process template", (Exception)throwable);
        }
        return stringWriter.toString();
    }

    @Override
    public String getTemplateName(String string) {
        Objects.requireNonNull(string, "templateName can not be null");
        return string.endsWith(TEMPLATE_SUFFIX) ? string : string + TEMPLATE_SUFFIX;
    }
}

