/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating.pebble;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import io.mangoo.core.Application;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.i18n.Messages;
import io.mangoo.models.Source;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.templating.TemplateEngine;
import io.mangoo.templating.pebble.tags.AuthenticityTag;
import io.mangoo.utils.ThrowableUtils;
import io.undertow.server.HttpServerExchange;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TemplateEnginePebble
implements TemplateEngine {
    private static final String TEMPLATE_SUFFIX = ".peb";
    private final PebbleEngine pebbleEngine = new PebbleEngine.Builder().build();

    @Override
    public String render(Flash flash, Session session, Form form, Messages messages, String string, Map<String, Object> map) throws MangooTemplateEngineException {
        PebbleTemplate pebbleTemplate;
        try {
            pebbleTemplate = this.pebbleEngine.getTemplate("templates/" + string);
        }
        catch (PebbleException pebbleException) {
            throw new MangooTemplateEngineException("Failed to render template", (Exception)((Object)pebbleException));
        }
        map.put("form", form);
        map.put("flash", flash);
        map.put("session", session);
        map.put("authenticity", new AuthenticityTag(session));
        return this.processTemplate(map, pebbleTemplate);
    }

    @Override
    public String render(String string, String string2, Map<String, Object> map) throws MangooTemplateEngineException {
        PebbleTemplate pebbleTemplate;
        try {
            pebbleTemplate = this.pebbleEngine.getTemplate(string + "/" + this.getTemplateName(string2));
        }
        catch (PebbleException pebbleException) {
            throw new MangooTemplateEngineException("Failed to render Template", (Exception)((Object)pebbleException));
        }
        return this.processTemplate(map, pebbleTemplate);
    }

    @Override
    public String renderException(HttpServerExchange httpServerExchange, Throwable throwable, boolean bl) throws MangooTemplateEngineException {
        String string;
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("templateException", bl);
        if (bl) {
            hashMap.put("exceptions", throwable.getMessage().split("\n"));
        } else {
            List<Source> list;
            object = Arrays.asList(throwable.getStackTrace()).get(0);
            string = ThrowableUtils.getSourceCodePath((StackTraceElement)object);
            try {
                list = ThrowableUtils.getSources(((StackTraceElement)object).getLineNumber(), string);
            }
            catch (IOException iOException) {
                throw new MangooTemplateEngineException("Failed to get source lines of exception", iOException);
            }
            hashMap.put("sources", list);
            hashMap.put("cause", ExceptionUtils.getMessage((Throwable)throwable));
            hashMap.put("url", httpServerExchange.getRequestURI());
            hashMap.put("method", httpServerExchange.getRequestMethod());
            hashMap.put("line", ((StackTraceElement)object).getLineNumber());
            hashMap.put("causeSource", throwable.toString());
            hashMap.put("stackTraces", throwable.getStackTrace());
            hashMap.put("sourceCodePath", StringUtils.substringAfter((String)new File(Application.getBaseDirectory()).toPath().resolve(string).toFile().getPath(), (String)"src/main/java") + " around line " + ((StackTraceElement)object).getLineNumber());
        }
        object = new StringWriter();
        try {
            string = this.pebbleEngine.getTemplate("exception.peb");
            string.evaluate((Writer)object, hashMap);
        }
        catch (PebbleException | IOException throwable2) {
            throw new MangooTemplateEngineException("Failed to process template", (Exception)throwable2);
        }
        return object.toString();
    }

    private String processTemplate(Map<String, Object> map, PebbleTemplate pebbleTemplate) throws MangooTemplateEngineException {
        Objects.requireNonNull(map, "content can not be null");
        Objects.requireNonNull(pebbleTemplate, "pebbleTemplate can not be null");
        StringWriter stringWriter = new StringWriter();
        try {
            pebbleTemplate.evaluate((Writer)stringWriter, map);
        }
        catch (PebbleException | IOException throwable) {
            throw new MangooTemplateEngineException("Failed to process template", (Exception)throwable);
        }
        return ((Object)stringWriter).toString();
    }

    @Override
    public String getTemplateName(String string) {
        Objects.requireNonNull(string, "templateName can not be null");
        return string.endsWith(TEMPLATE_SUFFIX) ? string : string + TEMPLATE_SUFFIX;
    }
}

