/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import io.advantageous.boon.json.JsonFactory;
import io.advantageous.boon.json.JsonSerializer;
import io.advantageous.boon.json.JsonSerializerFactory;
import io.advantageous.boon.json.ObjectMapper;
import java.util.Collection;
import java.util.Objects;

public final class JsonUtils {
    private static final String JSON_CAN_NOT_BE_NULL = "json can not be null";
    private static volatile JsonSerializer jsonSerializer = JsonUtils.createJsonSerializer();
    private static ObjectMapper objectMapper = JsonFactory.create();

    private JsonUtils() {
    }

    private static JsonSerializer createJsonSerializer() {
        JsonSerializerFactory jsonSerializerFactory = new JsonSerializerFactory();
        jsonSerializerFactory.useAnnotations();
        return jsonSerializerFactory.create();
    }

    public static void withJsonSerializer(JsonSerializer jsonSerializer) {
        JsonUtils.jsonSerializer = jsonSerializer;
    }

    public static String toJson(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        return jsonSerializer.serialize(object).toString();
    }

    public static ReadContext fromJson(String string) {
        Objects.requireNonNull(string, JSON_CAN_NOT_BE_NULL);
        return JsonPath.parse((String)string);
    }

    public static <T> T fromJson(String string, Class<T> clazz) {
        Objects.requireNonNull(string, JSON_CAN_NOT_BE_NULL);
        Objects.requireNonNull(clazz, "clazz can not be null");
        return (T)objectMapper.fromJson(string, clazz);
    }

    public static <T extends Collection<C>, C> T fromJson(String string, Class<C> clazz, Class<T> clazz2) {
        Objects.requireNonNull(string, JSON_CAN_NOT_BE_NULL);
        Objects.requireNonNull(clazz2, "clazz can not be null");
        Objects.requireNonNull(clazz, "componentType can not be null");
        return (T)objectMapper.readValue(string, clazz2, clazz);
    }
}

