/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.mangoo.configuration.Config;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Mode;
import io.mangoo.enums.Suffix;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.jawr.web.minification.CSSMinifier;
import net.jawr.web.minification.JSMin;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MinificationUtils {
    private static final Logger LOG = LogManager.getLogger(MinificationUtils.class);
    private static final int HUNDRED_PERCENT = 100;
    private static final String JS = "js";
    private static final String CSS = "css";
    private static final String LESS = "less";
    private static final String SASS = "sass";
    private static final String MIN = "min";
    private static String basePath;
    private static volatile Config config;

    private MinificationUtils() {
        config = new Config(basePath + Default.CONFIG_PATH.toString(), Mode.DEV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBasePath(String string) {
        Class<MinificationUtils> clazz = MinificationUtils.class;
        synchronized (MinificationUtils.class) {
            basePath = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(Config config) {
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            MinificationUtils.config = config;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void minify(String string) {
        if (string == null || string.contains(MIN)) {
            return;
        }
        if (config == null) {
            System.setProperty(Key.APPLICATION_CONFIG.toString(), basePath + Default.CONFIG_PATH.toString());
            config = new Config(basePath + Default.CONFIG_PATH.toString(), Mode.DEV);
        }
        if (config.isMinifyCSS() && string.endsWith(JS)) {
            MinificationUtils.minifyJS(new File(string));
        } else if (config.isMinifyJS() && string.endsWith(CSS)) {
            MinificationUtils.minifyCSS(new File(string));
        }
    }

    public static void preprocess(String string) {
        if (string == null) {
            return;
        }
        if (config == null) {
            System.setProperty(Key.APPLICATION_CONFIG.toString(), basePath + Default.CONFIG_PATH.toString());
            config = new Config(basePath + Default.CONFIG_PATH.toString(), Mode.DEV);
        }
        if (config.isPreprocessLess() && string.endsWith(LESS)) {
            MinificationUtils.lessify(new File(string));
        } else if (config.isPreprocessSass() && string.endsWith(SASS)) {
            MinificationUtils.sassify(new File(string));
        }
    }

    private static void lessify(File file) {
        DefaultLessCompiler defaultLessCompiler = new DefaultLessCompiler();
        try {
            File file2 = MinificationUtils.getOutputFile(file, Suffix.CSS);
            LessCompiler.CompilationResult compilationResult = defaultLessCompiler.compile(file);
            FileUtils.writeStringToFile((File)file2, (String)compilationResult.getCss(), (String)Default.ENCODING.toString());
            MinificationUtils.logPreprocess(file, file2);
        }
        catch (Less4jException | IOException throwable) {
            LOG.error("Failed to preprocess LESS file", throwable);
        }
    }

    private static void sassify(File file) {
        File file2 = MinificationUtils.getOutputFile(file, Suffix.CSS);
        URI uRI = file.toURI();
        URI uRI2 = file2.toURI();
        Compiler compiler = new Compiler();
        try {
            Output output = compiler.compileFile(uRI, uRI2, new Options());
            FileUtils.writeStringToFile((File)file2, (String)output.getCss(), (String)Default.ENCODING.toString());
            MinificationUtils.logPreprocess(file, file2);
        }
        catch (CompilationException | IOException throwable) {
            LOG.error("Failed to preprocess SASS file", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void minifyJS(File file) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File file2 = MinificationUtils.getOutputFile(file, Suffix.JS_MIN);
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            JSMin jSMin = new JSMin((InputStream)fileInputStream, (OutputStream)fileOutputStream);
            jSMin.jsmin();
            MinificationUtils.logMinification(file, file2);
        }
        catch (IOException | JSMin.JSMinException throwable) {
            try {
                LOG.error("Failed to minify JS", throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(fileInputStream);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable2;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
            IOUtils.closeQuietly(fileOutputStream);
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    private static void logMinification(File file, File file2) {
        LOG.info(String.format("Minified asset %s (%db) -> %s (%db) [compressed to %d%% of original size]", file.getName(), file.length(), file2.getName(), file2.length(), MinificationUtils.ratioOfSize(file, file2)));
    }

    private static void logPreprocess(File file, File file2) {
        LOG.info(String.format("Preprocessed asset %s -> %s", file.getName(), file2.getName()));
    }

    private static void minifyCSS(File file) {
        try {
            File file2 = MinificationUtils.getOutputFile(file, Suffix.CSS_MIN);
            StringBuffer stringBuffer = new StringBuffer();
            CSSMinifier cSSMinifier = new CSSMinifier();
            stringBuffer.append(FileUtils.readFileToString((File)file, (String)Default.ENCODING.toString()));
            StringBuffer stringBuffer2 = cSSMinifier.minifyCSS(stringBuffer);
            FileUtils.write((File)file2, (CharSequence)stringBuffer2.toString(), (String)Default.ENCODING.toString());
            MinificationUtils.logMinification(file, file2);
        }
        catch (IOException iOException) {
            LOG.error("Failed to minify CSS", (Throwable)iOException);
        }
    }

    private static File getOutputFile(File file, Suffix suffix) {
        String string;
        String string2 = file.getName();
        string2 = string2.substring(0, string2.lastIndexOf(46));
        string2 = string2 + suffix.toString();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        if ((string = config.getAssetsPath()).startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        String string3 = null;
        if (Suffix.CSS.equals((Object)suffix) || Suffix.CSS_MIN.equals((Object)suffix)) {
            string3 = Default.STYLESHEET_FOLDER.toString() + "/" + string2;
        } else if (Suffix.JS.equals((Object)suffix) || Suffix.JS_MIN.equals((Object)suffix)) {
            string3 = Default.JAVASCRIPT_FOLDER.toString() + "/" + string2;
        }
        return new File(basePath + string + string3);
    }

    private static long ratioOfSize(File file, File file2) {
        long l = Math.max(file.length(), 1L);
        long l2 = Math.max(file2.length(), 1L);
        return l2 * 100L / l;
    }
}

