/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.github.scribejava.apis.FacebookApi;
import com.github.scribejava.apis.GoogleApi20;
import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.oauth.OAuthService;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.crypto.Crypto;
import io.mangoo.enums.ContentType;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.oauth.OAuthProvider;
import io.mangoo.routing.Attachment;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Cookies;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.websockets.core.WebSocketChannel;
import java.net.URI;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public final class RequestUtils {
    public static final AttachmentKey<Attachment> ATTACHMENT_KEY = AttachmentKey.create(Attachment.class);
    private static final Config CONFIG = Application.getConfig();
    private static final String EXCHANGE_REQUIRED = "HttpServerExchange can not be null";
    private static final String SCOPE = "https://www.googleapis.com/auth/userinfo.email";
    private static final int MAX_RANDOM = 999999;
    private static final int AUTH_PREFIX_LENGTH = 3;
    private static final int INDEX_0 = 0;
    private static final int INDEX_1 = 1;
    private static final int INDEX_2 = 2;

    private RequestUtils() {
    }

    public static Map<String, String> getRequestParameters(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, EXCHANGE_REQUIRED);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map map = httpServerExchange.getQueryParameters();
        map.putAll(httpServerExchange.getPathParameters());
        map.entrySet().forEach(entry -> {
            String cfr_ignored_0 = (String)hashMap.put((String)entry.getKey(), (String)((Deque)entry.getValue()).element());
        });
        return hashMap;
    }

    public static boolean isPostOrPut(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, EXCHANGE_REQUIRED);
        return Methods.POST.equals(httpServerExchange.getRequestMethod()) || Methods.PUT.equals(httpServerExchange.getRequestMethod());
    }

    public static boolean isJsonRequest(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, EXCHANGE_REQUIRED);
        HeaderMap headerMap = httpServerExchange.getRequestHeaders();
        return headerMap != null && headerMap.get(Headers.CONTENT_TYPE) != null && headerMap.get(Headers.CONTENT_TYPE).element().toLowerCase(Locale.ENGLISH).contains(ContentType.APPLICATION_JSON.toString().toLowerCase());
    }

    public static Optional<OAuthService> createOAuthService(OAuthProvider oAuthProvider) {
        Objects.requireNonNull(oAuthProvider, "oAuthProvider can not be null");
        OAuthService oAuthService = null;
        switch (oAuthProvider) {
            case TWITTER: {
                oAuthService = new ServiceBuilder().callback(CONFIG.getString(Key.OAUTH_TWITTER_CALLBACK)).apiKey(CONFIG.getString(Key.OAUTH_TWITTER_KEY)).apiSecret(CONFIG.getString(Key.OAUTH_TWITTER_SECRET)).build((BaseApi)TwitterApi.instance());
                break;
            }
            case GOOGLE: {
                oAuthService = new ServiceBuilder().scope(SCOPE).callback(CONFIG.getString(Key.OAUTH_GOOGLE_CALLBACK)).apiKey(CONFIG.getString(Key.OAUTH_GOOGLE_KEY)).apiSecret(CONFIG.getString(Key.OAUTH_GOOGLE_SECRET)).state("secret" + new SecureRandom().nextInt(999999)).build((BaseApi)GoogleApi20.instance());
                break;
            }
            case FACEBOOK: {
                oAuthService = new ServiceBuilder().callback(CONFIG.getString(Key.OAUTH_FACEBOOK_CALLBACK)).apiKey(CONFIG.getString(Key.OAUTH_FACEBOOK_KEY)).apiSecret(CONFIG.getString(Key.OAUTH_FACEBOOK_SECRET)).build((BaseApi)FacebookApi.instance());
                break;
            }
        }
        return oAuthService == null ? Optional.empty() : Optional.of(oAuthService);
    }

    public static Optional<OAuthProvider> getOAuthProvider(String string) {
        OAuthProvider oAuthProvider = null;
        if (OAuthProvider.FACEBOOK.toString().equals(string)) {
            oAuthProvider = OAuthProvider.FACEBOOK;
        } else if (OAuthProvider.TWITTER.toString().equals(string)) {
            oAuthProvider = OAuthProvider.TWITTER;
        } else if (OAuthProvider.GOOGLE.toString().equals(string)) {
            oAuthProvider = OAuthProvider.GOOGLE;
        }
        return oAuthProvider == null ? Optional.empty() : Optional.of(oAuthProvider);
    }

    public static boolean hasValidAuthentication(String string) {
        Map map;
        String string2;
        boolean bl = false;
        if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)(string2 = ((Cookie)(map = Cookies.parseRequestCookies((int)1, (boolean)false, Arrays.asList(string))).get(CONFIG.getAuthenticationCookieName())).getValue())) && !"null".equals(string2)) {
            Object object;
            if (CONFIG.isAuthenticationCookieEncrypt()) {
                string2 = Application.getInstance(Crypto.class).decrypt(string2);
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = StringUtils.substringBefore((String)string2, (String)Default.DATA_DELIMITER.toString());
            if (StringUtils.isNotBlank((CharSequence)string6) && (object = string6.split("\\" + Default.DELIMITER.toString())) != null && ((String[])object).length == 3) {
                string3 = object[0];
                string4 = object[1];
                string5 = object[2];
            }
            if (StringUtils.isNotBlank(string3) && StringUtils.isNotBlank(string4)) {
                object = string2.substring(string2.indexOf(Default.DATA_DELIMITER.toString()) + 1, string2.length());
                LocalDateTime localDateTime = LocalDateTime.parse(string4);
                if (LocalDateTime.now().isBefore(localDateTime) && DigestUtils.sha512Hex((String)((String)object + string4 + string5 + CONFIG.getApplicationSecret())).equals(string3)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static String getServerSentEventURL(ServerSentEventConnection serverSentEventConnection) {
        return RequestUtils.getURL(URI.create(serverSentEventConnection.getRequestURI()));
    }

    public static String getWebSocketURL(WebSocketChannel webSocketChannel) {
        return RequestUtils.getURL(URI.create(webSocketChannel.getUrl()));
    }

    private static String getURL(URI uRI) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(uRI.getPath());
        if (StringUtils.isNotBlank((CharSequence)uRI.getQuery())) {
            stringBuilder.append('?').append(uRI.getQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)uRI.getFragment())) {
            stringBuilder.append('#').append(uRI.getFragment());
        }
        return stringBuilder.toString();
    }
}

