/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public final class SchedulerUtils {
    private SchedulerUtils() {
    }

    public static Trigger createTrigger(String string, String string2, String string3, String string4) {
        Objects.requireNonNull(string, "Identity is required for creating a new trigger");
        Objects.requireNonNull(string2, "groupName is required for new trigger");
        Objects.requireNonNull(string4, "cron is required for new trigger");
        Preconditions.checkArgument((boolean)CronExpression.isValidExpression((String)string4), (Object)"cron expression is invalid");
        return TriggerBuilder.newTrigger().withIdentity(string, string2).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string4)).withDescription(string3).build();
    }

    public static JobDetail createJobDetail(String string, String string2, Class<? extends Job> clazz) {
        Objects.requireNonNull(string, "identity is required for new JobDetail");
        Objects.requireNonNull(string2, "groupName is required for new JobDetail");
        Objects.requireNonNull(clazz, "clazz is required for new JobDetail");
        return JobBuilder.newJob(clazz).withIdentity(string, string2).build();
    }
}

