/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.mangoo.enums.Default;
import io.mangoo.enums.ErrorMessage;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TwoFactorUtils {
    private static final Logger LOG = LogManager.getLogger(TwoFactorUtils.class);
    private static final Base32 base32 = new Base32();
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String BLOCK_OF_ZEROS = "000000";
    private static final int TIME_STEP_SECONDS = 30;
    private static final boolean USE_SHA1_THREAD_LOCAL = true;
    private static final ThreadLocal<Mac> MAC_THREAD_LOCAL = new ThreadLocal<Mac>(){

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(TwoFactorUtils.HMAC_SHA1);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.error("Unknown message authentication code instance", (Throwable)noSuchAlgorithmException);
                return null;
            }
        }
    };

    private TwoFactorUtils() {
    }

    public static String generateBase32Secret() {
        return TwoFactorUtils.generateBase32Secret(16);
    }

    public static String generateBase32Secret(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int n2 = new SecureRandom().nextInt(32);
            if (n2 < 26) {
                stringBuilder.append((char)(65 + n2));
                continue;
            }
            stringBuilder.append((char)(50 + (n2 - 26)));
        }
        return stringBuilder.toString();
    }

    public static boolean validateCurrentNumber(int n, String string) {
        return TwoFactorUtils.validateCurrentNumber(n, string, 3);
    }

    public static boolean validateNumber(int n, String string, int n2, long l) {
        try {
            int n3 = Integer.parseInt(TwoFactorUtils.generateCurrentNumber(string, l));
            if (n == n3) {
                return true;
            }
            if (TwoFactorUtils.validateCurrentNumberLow(n, string, n2 - 1, l - 30000L)) {
                return true;
            }
            if (TwoFactorUtils.validateCurrentNumberHigh(n, string, n2 - 1, l + 30000L)) {
                return true;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error("Failed to validate number", (Throwable)generalSecurityException);
        }
        return false;
    }

    public static boolean validateCurrentNumber(int n, String string, int n2) {
        long l = System.currentTimeMillis();
        return TwoFactorUtils.validateNumber(n, string, n2, l);
    }

    private static boolean validateCurrentNumberLow(int n, String string, int n2, Long l) throws GeneralSecurityException {
        int n3 = Integer.parseInt(TwoFactorUtils.generateCurrentNumber(string, l));
        if (n3 == n) {
            return true;
        }
        if (n2 > 0) {
            return TwoFactorUtils.validateCurrentNumberLow(n, string, n2 - 1, l - 30000L);
        }
        return false;
    }

    private static boolean validateCurrentNumberHigh(int n, String string, int n2, long l) throws GeneralSecurityException {
        int n3 = Integer.parseInt(TwoFactorUtils.generateCurrentNumber(string, l));
        if (n3 == n) {
            return true;
        }
        if (n2 > 0) {
            return TwoFactorUtils.validateCurrentNumberHigh(n, string, n2 - 1, l + 30000L);
        }
        return false;
    }

    public static String getNumber(String string) {
        Objects.requireNonNull(string, ErrorMessage.SECRET.toString());
        return TwoFactorUtils.generateCurrentNumber(string, System.currentTimeMillis());
    }

    public static String generateCurrentNumber(String string) {
        return TwoFactorUtils.generateCurrentNumber(string, System.currentTimeMillis());
    }

    public static String generateCurrentNumber(String string, long l) {
        int n;
        Objects.requireNonNull(string, ErrorMessage.SECRET.toString());
        byte[] byArray = null;
        try {
            byArray = base32.decode(string.getBytes(Default.ENCODING.toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Failed to decode secrete to base32", (Throwable)unsupportedEncodingException);
        }
        byte[] byArray2 = new byte[8];
        long l2 = l / 1000L / 30L;
        int n2 = 7;
        while (l2 > 0L) {
            byArray2[n2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
            --n2;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, HMAC_SHA1);
        byte[] byArray3 = null;
        try {
            Mac mac = MAC_THREAD_LOCAL.get();
            mac.init(secretKeySpec);
            byArray3 = mac.doFinal(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error("Failed to encrypt data with key", (Throwable)generalSecurityException);
        }
        long l3 = 0L;
        for (int i = n = byArray3[byArray3.length - 1] & 0xF; i < n + 4; ++i) {
            l3 <<= 8;
            l3 |= (long)(byArray3[i] & 0xFF);
        }
        l3 &= Integer.MAX_VALUE;
        return TwoFactorUtils.zeroPrepend(l3 %= 1000000L, 0);
    }

    public static String getQRCode(String string, String string2) {
        Objects.requireNonNull(string, "accountName can not be null");
        Objects.requireNonNull(string2, "secret can not be null");
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("https://chart.googleapis.com/chart").append("?chs=200x200&cht=qr&chl=200x200&chld=M|0&cht=qr&chl=").append("otpauth://totp/").append(string).append("?secret=").append(string2);
        return stringBuilder.toString();
    }

    private static String zeroPrepend(long l, int n) {
        String string = Long.toString(l);
        if (string.length() >= n) {
            return string;
        }
        int n2 = n - string.length();
        StringBuilder stringBuilder = new StringBuilder(n).append(BLOCK_OF_ZEROS, 0, n2).append(string);
        return stringBuilder.toString();
    }
}

