/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.http;

import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.ContentType;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebResponse {
    private static final Logger LOG = LogManager.getLogger(WebResponse.class);
    private final CookieStore cookieStore = new BasicCookieStore();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
    private String responseUrl;
    private String responseUri;
    private String responseRequestBody;
    private String responseContent = "";
    private HttpString responseMethod;
    private HttpResponse httpResponse;
    private ContentType responseContentType;
    private HttpClientBuilder httpClientBuilder;
    private List<NameValuePair> postParameter = new ArrayList<NameValuePair>();
    private boolean responseDisbaleRedirects;
    private boolean hasFileBody;

    public WebResponse(String string, HttpString httpString) {
        this.responseUri = string;
        this.responseMethod = httpString;
        this.init();
    }

    public WebResponse() {
        this.init();
    }

    private void init() {
        Config config = Application.getInstance(Config.class);
        this.multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        String string = config.getString(Key.APPLICATION_HOST, Default.APPLICATION_HOST.toString());
        int n = config.getInt(Key.APPLICATION_PORT, Default.APPLICATION_PORT.toInt());
        this.cookieStore.clear();
        this.responseUrl = "http://" + string + ":" + n;
        this.httpClientBuilder = HttpClientBuilder.create().setDefaultCookieStore(this.cookieStore);
    }

    public WebResponse withContentType(ContentType contentType) {
        Objects.requireNonNull(contentType, "contentType can not be null");
        this.responseContentType = contentType;
        return this;
    }

    public WebResponse withRequestBody(String string) {
        this.responseRequestBody = string;
        return this;
    }

    public WebResponse withPostParameters(List<NameValuePair> list) {
        Objects.requireNonNull(list, "postParameter can not be null");
        this.postParameter = Collections.unmodifiableList(list);
        return this;
    }

    public WebResponse withDisableRedirects(boolean bl) {
        this.responseDisbaleRedirects = bl;
        return this;
    }

    public WebResponse withUri(String string) {
        Objects.requireNonNull(string, "uri can not be null");
        this.responseUri = string;
        return this;
    }

    public WebResponse withFileBody(String string, FileBody fileBody) {
        Objects.requireNonNull(fileBody, "fileBody can not be null");
        this.hasFileBody = true;
        this.multipartEntityBuilder.addPart(string, (ContentBody)fileBody);
        return this;
    }

    public WebResponse withMethod(HttpString httpString) {
        Objects.requireNonNull(httpString, "method can not be null");
        this.responseMethod = httpString;
        return this;
    }

    public WebResponse withHeader(String string, String string2) {
        Objects.requireNonNull(string, "name can not be null");
        Objects.requireNonNull(string2, "value can not be null");
        this.headers.put(string, string2);
        return this;
    }

    public WebResponse withCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie can not be null");
        this.cookieStore.addCookie(cookie);
        return this;
    }

    public WebResponse withBasicauthentication(String string, String string2) {
        Objects.requireNonNull(string, "username can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(string, string2));
        this.httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider).setDefaultCookieStore(this.cookieStore);
        return this;
    }

    public WebResponse execute() {
        if (Methods.GET.equals(this.responseMethod)) {
            HttpGet httpGet = new HttpGet(this.responseUrl + this.responseUri);
            return this.doRequest((HttpUriRequest)httpGet);
        }
        if (Methods.POST.equals(this.responseMethod)) {
            HttpPost httpPost = new HttpPost(this.responseUrl + this.responseUri);
            try {
                if (this.hasFileBody) {
                    httpPost.setEntity(this.multipartEntityBuilder.build());
                } else if (StringUtils.isNotBlank((CharSequence)this.responseRequestBody)) {
                    httpPost.setEntity((HttpEntity)new StringEntity(this.responseRequestBody));
                } else {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.postParameter, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error("Failed to create HttpPost request", (Throwable)unsupportedEncodingException);
            }
            return this.doRequest((HttpUriRequest)httpPost);
        }
        if (Methods.PUT.equals(this.responseMethod)) {
            HttpPut httpPut = new HttpPut(this.responseUrl + this.responseUri);
            try {
                if (StringUtils.isNotBlank((CharSequence)this.responseRequestBody)) {
                    httpPut.setEntity((HttpEntity)new StringEntity(this.responseRequestBody));
                } else {
                    httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(this.postParameter, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error("Failed to create HttpPut request", (Throwable)unsupportedEncodingException);
            }
            return this.doRequest((HttpUriRequest)httpPut);
        }
        if (Methods.DELETE.equals(this.responseMethod)) {
            HttpDelete httpDelete = new HttpDelete(this.responseUrl + this.responseUri);
            return this.doRequest((HttpUriRequest)httpDelete);
        }
        return this;
    }

    private WebResponse doRequest(HttpUriRequest httpUriRequest) {
        if (this.responseContentType != null) {
            httpUriRequest.setHeader("Content-Type", this.responseContentType.toString());
        }
        this.headers.entrySet().forEach(entry -> httpUriRequest.setHeader((String)entry.getKey(), (String)entry.getValue()));
        if (this.responseDisbaleRedirects) {
            this.httpClientBuilder.disableRedirectHandling();
        }
        try {
            this.httpResponse = this.httpClientBuilder.build().execute(httpUriRequest);
            HttpEntity httpEntity = this.httpResponse.getEntity();
            if (httpEntity != null) {
                this.responseContent = EntityUtils.toString((HttpEntity)httpEntity);
            }
        }
        catch (IOException iOException) {
            LOG.error("Failed to execute request to " + this.responseUrl, (Throwable)iOException);
        }
        return this;
    }

    public String getContent() {
        return this.responseContent;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getHeader(String string) {
        return this.httpResponse.getFirstHeader(string) == null ? null : this.httpResponse.getFirstHeader(string).getValue();
    }

    public List<Cookie> getCookies() {
        return this.cookieStore.getCookies();
    }

    public Cookie getCookie(String string) {
        for (Cookie cookie : this.cookieStore.getCookies()) {
            if (!string.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public String getContentType() {
        return this.httpResponse.getEntity().getContentType().getValue();
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }
}

